package org.simantics.db.layer0.request;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;

/**
 * Returns the active model or null if no single active model is available.
 */
public class PossibleActiveModel extends ResourceRead<Resource> {

    public PossibleActiveModel(Resource project) {
        super(project);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
        Collection<Resource> actives = graph.syncRequest(new ActiveModels(resource));
        if (actives.size() == 1)
            return actives.iterator().next();
        else
            return null;
    }

}
