/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.Pair;

public class NamedVariableChildren extends UnaryRead<Variable, Collection<Pair<String, Variable>>> {

    public NamedVariableChildren(Variable variable) {
        super(variable);
    }

    @Override
    public Collection<Pair<String, Variable>> perform(ReadGraph graph) throws DatabaseException {
    	ArrayList<Pair<String, Variable>> result = new ArrayList<Pair<String, Variable>>(); 
    	for(Variable child : parameter.getChildren(graph)) {
    		String name = child.getName(graph);
    		result.add(Pair.make(name, child));
    	}
    	return result;
    }

}
