package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.user.UserResource;

public class IsUserAssigned extends ResourceRead2<Boolean> {

    public IsUserAssigned(Resource assignment, Resource user) {
        super(assignment, user);
    }
    
    @Override
    public Boolean perform(ReadGraph graph) throws DatabaseException {
        UserResource USER = UserResource.getInstance(graph);
        for(Resource group : graph.getObjects(resource, USER.RoleAssignment_HasGroup)) {
            if(graph.syncRequest(new IsUserInGroup(resource2, group))) return true;
        }
        return false;
    }
    
}