package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.operation.Layer0X;

public class IsModelActive extends ResourceRead<Boolean> {

    public IsModelActive(Resource resource) {
        super(resource);
    }

    @Override
    public Boolean perform(ReadGraph graph) throws DatabaseException {
    	Resource model = graph.sync(new PossibleModel(resource));
    	if(model == null) return false;
    	return graph.hasStatement(model, Layer0X.getInstance(graph).IsActivatedBy);
    }

}
