/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.common.ReadQueryFactory;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.QueryDeserializer;
import org.simantics.db.request.Read;

public class HasEnumerationRangeFactory extends ReadQueryFactory<Boolean> {

	public Read<Boolean> readKey(QueryDeserializer deserializer) throws DatabaseException {
		return new HasEnumerationRange(deserializer.readResource());
	}
	
	public Boolean readValue(QueryDeserializer deserializer) throws DatabaseException {
		byte b = deserializer.readByte();
		return b == 1 ? Boolean.TRUE : Boolean.FALSE;
	}

}
