package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;

public class ClassificationsRequest extends UnaryRead<Collection<Resource>, Set<String>> {

	public ClassificationsRequest(Collection<Resource> principalTypes) {
		super(principalTypes);
	}

	@Override
	public Set<String> perform(ReadGraph graph) throws DatabaseException {
    	Set<String> result = new HashSet<String>(parameter.size());
    	Set<Resource> allTypes = new HashSet<Resource>(parameter);
    	for(Resource principalType : parameter) allTypes.addAll(graph.getSupertypes(principalType));
    	for(Resource type : allTypes) {
    		String uri = graph.getPossibleURI(type);
    		if(uri != null) result.add(uri);
    	}
    	return result;
	}

}
