package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.SessionModel;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.operation.Layer0X;
import org.simantics.user.UserResource;

public class ActiveSessionRole extends ResourceRead<Resource> {

    public ActiveSessionRole(Resource model) {
        super(model);
    }
    
    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance(graph);
        UserResource USER = UserResource.getInstance(graph);
        Resource session = graph.getService(SessionModel.class).getResource();
        for(Resource selection : graph.getObjects(session, L0X.Session_HasRoleSelection)) {
            Resource model = graph.getPossibleObject(selection, USER.RoleSelection_HasModel);
            if(model.equals(resource)) {
                return graph.getPossibleObject(selection, USER.RoleSelection_HasRole);
            }
        }
        return USER.DefaultRole;
    }
    
}