package org.simantics.db.layer0.property;

import java.util.ArrayList;
import java.util.Collections;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.operation.Layer0X;

/**
 * @author Antti Villberg
 * TODO: consider removing since this doesn't seem to be used.
 */
public class Properties {
	
	public static <T> T getPossibleRelatedValue(ReadGraph graph, Resource resource, Resource relation, Binding binding) throws DatabaseException {
		
		T result = graph.getPossibleRelatedValue(resource, relation, binding);
		if(result != null) return result;
		else {
			
		    Layer0X L0X = Layer0X.getInstance(graph);
			ArrayList<OrderedResource> order = new ArrayList<OrderedResource>();
			for(Statement stm : graph.getStatements(resource, L0X.ObtainsProperty)) {
				Integer position = graph.getRelatedValue(stm.getPredicate(), L0X.NaturalNumberOrderRelation, Bindings.INTEGER);
				order.add(new OrderedResource(position, stm.getObject()));
			}
			Collections.sort(order);
			for(OrderedResource or : order) {
				result = getPossibleRelatedValue(graph, or.r, relation, binding);
				if(result != null) return result;
			}
			
			return null;
			
		}
		
	}

	public static <T> T getPossibleRelatedAdapter(ReadGraph graph, Resource resource, Resource relation, Class<T> clazz) throws DatabaseException {

		T result = graph.getPossibleRelatedAdapter(resource, relation, clazz);
		if(result != null) return result;
		else {
			
		    Layer0X L0X = Layer0X.getInstance(graph);
			ArrayList<OrderedResource> order = new ArrayList<OrderedResource>();
			for(Statement stm : graph.getStatements(resource, L0X.ObtainsProperty)) {
				Integer position = graph.getRelatedValue(stm.getPredicate(), L0X.NaturalNumberOrderRelation, Bindings.INTEGER);
				order.add(new OrderedResource(position, stm.getObject()));
			}
			Collections.sort(order);
			for(OrderedResource or : order) {
				result = getPossibleRelatedAdapter(graph, or.r, relation, clazz);
				if(result != null) return result;
			}
			
			return null;
			
		}
		
	}

}
