package org.simantics.db.layer0.migration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Namespace configuration for namespace migration down with AdaptingTransferableGraphFileReader
 * 
 * This is different to NamespaceMigrationStep.
 * 
 *  NamespaceMigrationStep reads whole TG to memory, while AdaptingTransferableGraphFileReader implements streaming version.
 *  NamespaceMigrationStep allows multi-stage migrations, AdaptingTransferableGraphFileReader does not.
 *  NamespaceMigrationStep is tested implementation, AdaptingTransferableGraphFileReader is not!
 * 
 * @author MarkoLuukkainen
 *
 */
public class NamespaceConfiguration {
	Map<String,String> conversion;
	Set<String> ignore;
	
	public NamespaceConfiguration() {
		conversion = new HashMap<>();
		ignore = new HashSet<>();
	}
	
	public void merge(NamespaceConfiguration conf) {
		this.conversion.putAll(conf.conversion);
		this.ignore.addAll(conf.ignore);
	}
	
	public void convert(String uri1, String uri2) {
		conversion.put(uri1, uri2);
	}
	
	public void convert(Map<String,String> uris) {
		conversion.putAll(uris);
	}
	
	public void ignore(String uri) {
		ignore.add(uri);
	}
	
	public void ignore(Set<String> uris) {
		ignore.addAll(uris);
	}

}
