/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.genericrelation;

import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.combinators.SelectByRelation;
import org.simantics.db.layer0.genericrelation.combinators.Selection;

/**
 * Default implementation for some methods of IRelation interface.
 */
public abstract class AbstractRelation implements GenericRelation {

	@Override
	public boolean isRealizable() {
		return false;
	}

	@Override
	public List<Object[]> realize(ReadGraph g) throws DatabaseException {
		throw new UnsupportedOperationException();
	}

	@Override
	public GenericRelation select(String bindingPattern, Object[] constants) {
		return new Selection(this, bindingPattern, constants);
	}
	
	@Override
	public GenericRelation selectByRelation(String bindingPattern, GenericRelation constraint) {
		return new SelectByRelation(this, bindingPattern, constraint);
	}

}
