/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.layer0.Layer0;

public class RootParentSubgraphExtent extends TypeSubgraphExtent {

	public static boolean DEBUG = false;
	
	final private Classifier classifier;
	
	public RootParentSubgraphExtent(final Resource root) {
		this.classifier = new Classifier() {

			@Override
			public void classify(AsyncReadGraph graph, Statement statement, ExtentStatus objectExtent, Callback callback) {
				if(!root.equals(statement.getSubject())) return;
				if(!graph.getService(Layer0.class).PartOf.equals(statement.getPredicate())) return;
				if(!ExtentStatus.EXTERNAL.equals(objectExtent)) return;
				callback.statement(statement, true); 
			}
			
		};
	}

	@Override
	public void accept(AsyncReadGraph graph, final Resource resource, final AsyncProcedure<Classifier> procedure, final Callback callback) {
		procedure.execute(graph, classifier);
	}

}
