/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import java.util.Map;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Template;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;

public class GraphTemplate implements Template {

    String[] parameters;
    TransferableGraph1 tg;
    
    public GraphTemplate(String[] parameters, TransferableGraph1 tg) {
        this.parameters = parameters;
        this.tg = tg;
    }

    public static GraphTemplate create(ReadGraph g, Resource r) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(g);
        String[] parameters = g.getRelatedValue(r, l0.HasTemplateParameters, Bindings.STRING_ARRAY);
        TransferableGraph1 tg = g.getRelatedValue(r, l0.HasTemplate, TransferableGraph1.BINDING);
        return new GraphTemplate(parameters, tg);
    }

    @Override
    public void apply(WriteGraph graph, final Map<String, Object> parameters)
            throws DatabaseException {
        TransferableGraphs.importGraph1(graph, tg, new IImportAdvisor() {
            @Override
            public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
                String name = root.name;
                Object obj = parameters.get(name);
                if(obj == null) {
                    Resource r = graph.newResource();
                    parameters.put(name, r);
                    return r;
                }
                else {
                    Resource r;
                    if(obj instanceof Resource)
                        r = (Resource)obj;
                    else {
                        r = graph.newResource();
                        graph.claimValue(r, obj);
                    }
                    return r;
                }
            }

            @Override
            public Resource analyzeRoot(ReadGraph graph, Root root) throws DatabaseException {
            	return null;
            }
        });
    }
    
}
