/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.ResourceToURI;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Valuations;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.Pair;

public class DefaultValuations implements Valuations {

	final private Resource resource;
	
	public DefaultValuations(Resource module) {
		this.resource = module;
	}

	public static Pair<String, String> splitModelAndStructure(ReadGraph graph, String path, int startPosition) throws DatabaseException {
		int position = path.indexOf("/", startPosition);
		String prefix = path.substring(0, position);
//		System.out.println("prefix=" + prefix);
		Resource r = graph.getResource(prefix);
		if(graph.isInstanceOf(r, SimulationResource.getInstance(graph).Model)) {
			return new Pair<String, String>(path.substring(0, position), path.substring(position+1, path.length())); 
		} else {
			return splitModelAndStructure(graph, path, position + 1);
		}
	}

	public static Pair<String, String> splitModelAndStructure(ReadGraph graph, String path) throws DatabaseException {
		Resource r = graph.getResource(path);
		if(graph.isInstanceOf(r, SimulationResource.getInstance(graph).Model)) {
			return new Pair<String, String>(path, "");
		} else {
			return splitModelAndStructure(graph, path, 8);
		}
	}
	
	@Override
	public Resource getValue(ReadGraph graph, String variableIdentityPrefix, String experiment) throws DatabaseException {
//		System.out.println("getValue " + module);
		String path = graph.syncRequest(new ResourceToURI(resource));
//		System.out.println("path=" + path);
		Pair<String, String> modelAndStructure = splitModelAndStructure(graph, path);
//		System.out.println("mas=" + modelAndStructure);
		// TODO: fixme please
		try {
			return graph.getResource(modelAndStructure.first + "/" + experiment + "/" + modelAndStructure.second);
		} catch (DatabaseException e) {
			try {
				return graph.getResource(modelAndStructure.first + "/BaseRealization/" + modelAndStructure.second);
			} catch (DatabaseException e2) {
				return null;
			}
		}
	}

	@Override
	public Resource getValue(ReadGraph graph, String variableIdentityPrefix, String experiment, String suffix) throws DatabaseException {
//		System.out.println("getValue " + resource);
		String path = graph.syncRequest(new ResourceToURI(resource));
//		System.out.println("path=" + path);
		Pair<String, String> modelAndStructure = splitModelAndStructure(graph, path);
//		System.out.println("mas=" + modelAndStructure);
		String prefix = modelAndStructure.second.isEmpty() ? "" : "/" + modelAndStructure.second;
		String uri = modelAndStructure.first + "/" + experiment + prefix + (suffix.isEmpty() ? "" : "/" + suffix);
//		System.out.println("defaultValuations uri=" + uri);
		return graph.getResource(uri);
	}

	
}
