/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public interface StringModifierFactory {

    /**
     * @param graph database read access
     * @param relation the property relation
     * @param property the current property value resource or <code>null</code>
     *        if no property currently exists
     * @return <code>null</code> if no modifier is available for the requested
     *         property
     * @throws DatabaseException 
     */
    StringModifier createModifier(ReadGraph graph, Resource relation, Resource property) throws DatabaseException;

}
