/*******************************************************************************
 * Copyright (c) 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IAdaptable;

/**
 * @author Antti Villberg
 * @since 1.61.0 
 */
public class SimanticsActionContext implements IAdaptable {

	private Map<Class<?>,Object> items = new HashMap<>();

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getAdapter(Class<T> adapter) {
		return (T) items.get(adapter);
	}

	public <T> void registerAdapter(Class<T> clazz, T adapter) {
		items.put(clazz, adapter);
	}

}
