/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.adapter;

import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleAdapter;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;

/**
 * @author Tuukka Lehtonen
 */
public class RVIStringAdapter extends SimpleAdapter<String> {

    @Override
    public String adapt(ReadGraph graph, Resource r) throws DatabaseException {
    	Binding rviBinding = graph.getService(Databoard.class).getBindingUnchecked( RVI.class );
        RVI rvi = graph.getValue(r, rviBinding);
        try {
            return rvi.toString(graph);
        } catch (AdaptionException e) {
            return rvi.toString();
        }
    }

}
