package org.simantics.db.layer0.adapter;

import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class LiteralVariableStringAdapter implements Adapter<String, Variable> {

    @Override
    public void adapt(AsyncReadGraph g, final Resource source, final Variable variable, final AsyncProcedure<String> procedure) {
    	g.asyncRequest(new Read<String>() {

			@Override
			public String perform(ReadGraph graph) throws DatabaseException {
				
				Resource literal = variable.getPossibleRepresents(graph);
				String label = graph.getPossibleRelatedAdapter(literal, graph.getService(Layer0.class).HasLabel, String.class);
				if(label != null) return label;
				String name = graph.getPossibleRelatedValue(literal, graph.getService(Layer0.class).HasName, Bindings.STRING);
				if(name != null) return name;
				
				Object value = variable.getValue(graph);
				Formatter formatter = graph.getPossibleContextualAdapter(literal, variable, Variable.class, Formatter.class);
				if(formatter != null) {
					return formatter.format(value);
				} else {
					return value == null ? "<no value>" : value.toString();
				}
				
			}
    		
    	}, procedure);
    }
    
}
