package org.simantics.db.layer0.adapter;

import java.util.Arrays;

import org.simantics.databoard.Bindings;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.procedure.AsyncProcedure;

public class LiteralDoubleArrayStringAdapter implements Adapter<String, RelationContext> {

    @Override
    public void adapt(AsyncReadGraph g, Resource source, RelationContext s, final AsyncProcedure<String> procedure) {
        g.forValue(s.getStatement().getObject(), Bindings.DOUBLE_ARRAY, new  ProcedureWrapper(procedure));
    }
    
    private static class ProcedureWrapper implements AsyncProcedure<double[]> {
    	AsyncProcedure<String> procedure;
    	
    	public ProcedureWrapper(AsyncProcedure<String> procedure) {
			this.procedure = procedure;
		}
    	
    	public void execute(AsyncReadGraph graph, double[] result) {
    		procedure.execute(graph, Arrays.toString(result));
    	};
    	
    	@Override
    	public void exception(AsyncReadGraph graph, Throwable throwable) {
    		procedure.exception(graph, throwable);
    		
    	}
    }
    
}
