/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.UnaryQueryPIntSet;

public final class SuperRelations
extends UnaryQueryPIntSet {
    public SuperRelations(int resource) {
        super(resource);
    }

    static final SuperRelations entry(QueryProcessor provider, int r) {
        return (SuperRelations)provider.cache.superRelationsMap.get(r);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    @Override
    public void compute(ReadGraphImpl graph, InternalProcedure<IntSet> procedure) throws DatabaseException {
        SuperRelations.computeForEach(graph, this.id, this, procedure);
    }

    public static Object computeForEach(final ReadGraphImpl graph, int id, final SuperRelations entry, InternalProcedure<IntSet> procedure_) throws DatabaseException {
        InternalProcedure<IntSet> procedure = entry != null ? entry : procedure_;
        QueryProcessor processor = graph.processor;
        processor.querySupport.ensureLoaded(graph, id);
        final InternalProcedure<IntSet> proc = procedure;
        int subrelationOf = processor.getSubrelationOf();
        final IntSet result = new IntSet(processor.querySupport);
        final DirectProcedure directProc = new DirectProcedure(result, proc);
        processor.querySupport.getObjects(graph, id, subrelationOf, directProc);
        int size = directProc.size();
        if (size == 0) {
            proc.execute(graph, IntSet.EMPTY);
        } else if (size == 1) {
            result.add(directProc.single);
            QueryCache.runnerSuperRelations(graph, directProc.single, entry, null, directProc);
        } else {
            final TIntProcedure addToResult = new TIntProcedure(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean execute(int r) {
                    IntSet intSet = result;
                    synchronized (intSet) {
                        result.add(r);
                    }
                    return true;
                }
            };
            final AtomicInteger finishes = new AtomicInteger(0);
            directProc.forEach(new TIntProcedure(){

                public boolean execute(int arg0) {
                    try {
                        return this.execute0(arg0);
                    }
                    catch (DatabaseException e) {
                        Logger.defaultLogError((Throwable)e);
                        return false;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean execute0(int arg0) throws DatabaseException {
                    IntSet intSet = result;
                    synchronized (intSet) {
                        result.add(arg0);
                    }
                    QueryCache.runnerSuperRelations(graph, arg0, entry, null, new InternalProcedure<IntSet>(){

                        @Override
                        public void execute(ReadGraphImpl graph, IntSet set) throws DatabaseException {
                            set.forEach(addToResult);
                            int current = finishes.addAndGet(1);
                            if (current == directProc.size()) {
                                proc.execute(graph, result);
                                return;
                            }
                        }

                        @Override
                        public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                            proc.exception(graph, t);
                        }
                    });
                    return true;
                }
            });
        }
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
        return result;
    }

    public String toString() {
        return "SuperRelations[" + this.id + "]";
    }

    static class DirectProcedure
    extends Ints
    implements IntProcedure,
    TIntProcedure,
    InternalProcedure<IntSet> {
        IntSet result;
        InternalProcedure<IntSet> proc;

        public DirectProcedure(IntSet result, InternalProcedure<IntSet> proc) {
            this.result = result;
            this.proc = proc;
        }

        public final boolean execute(int r) {
            this.result.add(r);
            return true;
        }

        @Override
        public final void execute(ReadGraphImpl graph, int r) {
            if (this.single == 0) {
                this.single = r;
                return;
            }
            this.add(r);
        }

        @Override
        public final void execute(ReadGraphImpl graph, IntSet set) throws DatabaseException {
            set.forEach(this);
            this.proc.execute(graph, this.result);
        }

        @Override
        public void finished(ReadGraphImpl graph) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable t) {
            throw new Error("Errors are not supported.", t);
        }
    }

    static class Ints {
        private TIntHashSet set = null;
        public int single = 0;

        Ints() {
        }

        public boolean add(int val) {
            if (this.single == val) {
                return false;
            }
            if (this.single == 0) {
                this.single = val;
                return true;
            }
            if (this.set == null) {
                this.set = new TIntHashSet(4);
            }
            return this.set.add(val);
        }

        public int size() {
            if (this.single == 0) {
                return 0;
            }
            if (this.set == null) {
                return 1;
            }
            return this.set.size() + 1;
        }

        public void forEach(TIntProcedure proc) {
            if (this.single > 0) {
                proc.execute(this.single);
            }
            if (this.set != null) {
                this.set.forEach(proc);
            }
        }
    }
}

