/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.ext.DualIdContainer;
import gnu.trove.ext.DualIdContainerHashMapWithPrimaryIdLookup;
import gnu.trove.ext.IdContainer;
import gnu.trove.ext.IdContainerHashMap;
import gnu.trove.ext.StableHashMap;
import gnu.trove.map.hash.THashMap;
import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.RelationInfo;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.AssertedPredicates;
import org.simantics.db.impl.query.AssertedStatements;
import org.simantics.db.impl.query.AsyncMultiReadEntry;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.ChildMap;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.DirectSuperRelations;
import org.simantics.db.impl.query.ExternalReadEntry;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.MultiReadEntry;
import org.simantics.db.impl.query.Objects;
import org.simantics.db.impl.query.OrderedSet;
import org.simantics.db.impl.query.Predicates;
import org.simantics.db.impl.query.PrincipalTypes;
import org.simantics.db.impl.query.QueryCacheBase;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.RelationInfoQuery;
import org.simantics.db.impl.query.Statements;
import org.simantics.db.impl.query.SuperRelations;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.impl.query.TypeHierarchy;
import org.simantics.db.impl.query.Types;
import org.simantics.db.impl.query.URIToResource;
import org.simantics.db.impl.query.ValueQuery;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;

public class QueryCache
extends QueryCacheBase {
    public QueryCache(QuerySupport querySupport, int threads) {
        super(querySupport, threads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Objects getOrCreateObjects(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        Objects existing = null;
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.objectsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            existing = (Objects)this.objectsMap.get(r1, r2);
            if (existing == null) {
                existing = new Objects(r1, r2);
                existing.setPending(this.querySupport);
                this.objectsMap.put(QueryCache.keyR2(r1, r2), (DualIdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Objects entry) {
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.objectsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            this.objectsMap.remove(entry.id);
        }
    }

    public static void runnerObjects(ReadGraphImpl graph, int r1, int r2, CacheEntry<?> parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        IntProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r1, r2)) {
            Objects e = cache.peekObjects(r1, r2);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            Objects.computeForEach(graph, r1, r2, null, procedure);
            return;
        }
        Objects entry = cache.getOrCreateObjects(graph, r1, r2);
        IntProcedure intProcedure = procedure_ = procedure != null ? procedure : emptyProcedureObjects;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            Objects.computeForEach(graph, r1, r2, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Objects peekObjects(int r1, int r2) {
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.objectsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            return (Objects)this.objectsMap.get(r1, r2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Statements getOrCreateStatements(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        Statements existing = null;
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.statementsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            existing = (Statements)this.statementsMap.get(r1, r2);
            if (existing == null) {
                existing = new Statements(r1, r2);
                existing.setPending(this.querySupport);
                this.statementsMap.put(QueryCache.keyR2(r1, r2), (DualIdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Statements entry) {
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.statementsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            this.statementsMap.remove(entry.id);
        }
    }

    public static void runnerStatements(ReadGraphImpl graph, int r1, int r2, CacheEntry<?> parent, ListenerBase listener, TripleIntProcedure procedure) throws DatabaseException {
        TripleIntProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r1, r2)) {
            Statements e = cache.peekStatements(r1, r2);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            Statements.computeForEach(graph, r1, r2, null, procedure);
            return;
        }
        Statements entry = cache.getOrCreateStatements(graph, r1, r2);
        TripleIntProcedure tripleIntProcedure = procedure_ = procedure != null ? procedure : emptyProcedureStatements;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            Statements.computeForEach(graph, r1, r2, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statements peekStatements(int r1, int r2) {
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.statementsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            return (Statements)this.statementsMap.get(r1, r2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectObjects getOrCreateDirectObjects(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        DirectObjects existing = null;
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.directObjectsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            existing = (DirectObjects)this.directObjectsMap.get(r1, r2);
            if (existing == null) {
                existing = new DirectObjects(r1, r2);
                existing.setPending(this.querySupport);
                this.directObjectsMap.put(QueryCache.keyR2(r1, r2), (DualIdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DirectObjects entry) {
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.directObjectsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            this.directObjectsMap.remove(entry.id);
        }
    }

    public static void runnerDirectObjects(ReadGraphImpl graph, int r1, int r2, CacheEntry<?> parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        IntProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r1, r2)) {
            DirectObjects e = cache.peekDirectObjects(r1, r2);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            DirectObjects.computeForEach(graph, r1, r2, null, procedure);
            return;
        }
        DirectObjects entry = cache.getOrCreateDirectObjects(graph, r1, r2);
        IntProcedure intProcedure = procedure_ = procedure != null ? procedure : emptyProcedureDirectObjects;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            DirectObjects.computeForEach(graph, r1, r2, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectObjects peekDirectObjects(int r1, int r2) {
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.directObjectsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            return (DirectObjects)this.directObjectsMap.get(r1, r2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelationInfoQuery getOrCreateRelationInfoQuery(ReadGraphImpl graph, int r) throws DatabaseException {
        RelationInfoQuery existing = null;
        IdContainerHashMap idContainerHashMap = this.relationInfoQueryMap;
        synchronized (idContainerHashMap) {
            existing = (RelationInfoQuery)this.relationInfoQueryMap.get(r);
            if (existing == null) {
                existing = new RelationInfoQuery(r);
                existing.setPending(this.querySupport);
                this.relationInfoQueryMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(RelationInfoQuery entry) {
        IdContainerHashMap idContainerHashMap = this.relationInfoQueryMap;
        synchronized (idContainerHashMap) {
            this.relationInfoQueryMap.remove(entry.id);
        }
    }

    public static void runnerRelationInfoQuery(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, InternalProcedure<RelationInfo> procedure) throws DatabaseException {
        InternalProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            RelationInfoQuery e = cache.peekRelationInfoQuery(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            RelationInfoQuery.computeForEach(graph, r, null, procedure);
            return;
        }
        RelationInfoQuery entry = cache.getOrCreateRelationInfoQuery(graph, r);
        InternalProcedure internalProcedure = procedure_ = procedure != null ? procedure : emptyProcedureRelationInfoQuery;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            RelationInfoQuery.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelationInfoQuery peekRelationInfoQuery(int r) {
        IdContainerHashMap idContainerHashMap = this.relationInfoQueryMap;
        synchronized (idContainerHashMap) {
            return (RelationInfoQuery)this.relationInfoQueryMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URIToResource getOrCreateURIToResource(ReadGraphImpl graph, String id) throws DatabaseException {
        URIToResource existing = null;
        THashMap tHashMap = this.uRIToResourceMap;
        synchronized (tHashMap) {
            existing = (URIToResource)this.uRIToResourceMap.get((Object)id);
            if (existing == null) {
                existing = new URIToResource(id);
                existing.setPending(this.querySupport);
                this.uRIToResourceMap.put((Object)QueryCache.keyID(id), (Object)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(URIToResource entry) {
        THashMap tHashMap = this.uRIToResourceMap;
        synchronized (tHashMap) {
            this.uRIToResourceMap.remove((Object)entry.id);
        }
    }

    public static void runnerURIToResource(ReadGraphImpl graph, String id, CacheEntry<?> parent, ListenerBase listener, InternalProcedure<Integer> procedure) throws DatabaseException {
        InternalProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, id)) {
            URIToResource e = cache.peekURIToResource(id);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            URIToResource.computeForEach(graph, id, null, procedure);
            return;
        }
        URIToResource entry = cache.getOrCreateURIToResource(graph, id);
        InternalProcedure internalProcedure = procedure_ = procedure != null ? procedure : emptyProcedureURIToResource;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            URIToResource.computeForEach(graph, id, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URIToResource peekURIToResource(String id) {
        THashMap tHashMap = this.uRIToResourceMap;
        synchronized (tHashMap) {
            return (URIToResource)this.uRIToResourceMap.get((Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueQuery getOrCreateValueQuery(ReadGraphImpl graph, int r) throws DatabaseException {
        ValueQuery existing = null;
        IdContainerHashMap idContainerHashMap = this.valueQueryMap;
        synchronized (idContainerHashMap) {
            existing = (ValueQuery)this.valueQueryMap.get(r);
            if (existing == null) {
                existing = new ValueQuery(r);
                existing.setPending(this.querySupport);
                this.valueQueryMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ValueQuery entry) {
        IdContainerHashMap idContainerHashMap = this.valueQueryMap;
        synchronized (idContainerHashMap) {
            this.valueQueryMap.remove(entry.id);
        }
    }

    public static void runnerValueQuery(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, InternalProcedure<byte[]> procedure) throws DatabaseException {
        InternalProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            ValueQuery e = cache.peekValueQuery(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            ValueQuery.computeForEach(graph, r, null, procedure);
            return;
        }
        ValueQuery entry = cache.getOrCreateValueQuery(graph, r);
        InternalProcedure internalProcedure = procedure_ = procedure != null ? procedure : emptyProcedureValueQuery;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            ValueQuery.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueQuery peekValueQuery(int r) {
        IdContainerHashMap idContainerHashMap = this.valueQueryMap;
        synchronized (idContainerHashMap) {
            return (ValueQuery)this.valueQueryMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OrderedSet getOrCreateOrderedSet(ReadGraphImpl graph, int r) throws DatabaseException {
        OrderedSet existing = null;
        IdContainerHashMap idContainerHashMap = this.orderedSetMap;
        synchronized (idContainerHashMap) {
            existing = (OrderedSet)this.orderedSetMap.get(r);
            if (existing == null) {
                existing = new OrderedSet(r);
                existing.setPending(this.querySupport);
                this.orderedSetMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(OrderedSet entry) {
        IdContainerHashMap idContainerHashMap = this.orderedSetMap;
        synchronized (idContainerHashMap) {
            this.orderedSetMap.remove(entry.id);
        }
    }

    public static void runnerOrderedSet(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        IntProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            OrderedSet e = cache.peekOrderedSet(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            OrderedSet.computeForEach(graph, r, null, procedure);
            return;
        }
        OrderedSet entry = cache.getOrCreateOrderedSet(graph, r);
        IntProcedure intProcedure = procedure_ = procedure != null ? procedure : emptyProcedureOrderedSet;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            OrderedSet.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderedSet peekOrderedSet(int r) {
        IdContainerHashMap idContainerHashMap = this.orderedSetMap;
        synchronized (idContainerHashMap) {
            return (OrderedSet)this.orderedSetMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrincipalTypes getOrCreatePrincipalTypes(ReadGraphImpl graph, int r) throws DatabaseException {
        PrincipalTypes existing = null;
        IdContainerHashMap idContainerHashMap = this.principalTypesMap;
        synchronized (idContainerHashMap) {
            existing = (PrincipalTypes)this.principalTypesMap.get(r);
            if (existing == null) {
                existing = new PrincipalTypes(r);
                existing.setPending(this.querySupport);
                this.principalTypesMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(PrincipalTypes entry) {
        IdContainerHashMap idContainerHashMap = this.principalTypesMap;
        synchronized (idContainerHashMap) {
            this.principalTypesMap.remove(entry.id);
        }
    }

    public static void runnerPrincipalTypes(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        IntProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            PrincipalTypes e = cache.peekPrincipalTypes(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            PrincipalTypes.computeForEach(graph, r, null, procedure);
            return;
        }
        PrincipalTypes entry = cache.getOrCreatePrincipalTypes(graph, r);
        IntProcedure intProcedure = procedure_ = procedure != null ? procedure : emptyProcedurePrincipalTypes;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            PrincipalTypes.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrincipalTypes peekPrincipalTypes(int r) {
        IdContainerHashMap idContainerHashMap = this.principalTypesMap;
        synchronized (idContainerHashMap) {
            return (PrincipalTypes)this.principalTypesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectPredicates getOrCreateDirectPredicates(ReadGraphImpl graph, int r) throws DatabaseException {
        DirectPredicates existing = null;
        IdContainerHashMap idContainerHashMap = this.directPredicatesMap;
        synchronized (idContainerHashMap) {
            existing = (DirectPredicates)this.directPredicatesMap.get(r);
            if (existing == null) {
                existing = new DirectPredicates(r);
                existing.setPending(this.querySupport);
                this.directPredicatesMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DirectPredicates entry) {
        IdContainerHashMap idContainerHashMap = this.directPredicatesMap;
        synchronized (idContainerHashMap) {
            this.directPredicatesMap.remove(entry.id);
        }
    }

    public static void runnerDirectPredicates(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        InternalProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            DirectPredicates e = cache.peekDirectPredicates(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            DirectPredicates.computeForEach(graph, r, null, procedure);
            return;
        }
        DirectPredicates entry = cache.getOrCreateDirectPredicates(graph, r);
        InternalProcedure internalProcedure = procedure_ = procedure != null ? procedure : emptyProcedureDirectPredicates;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            DirectPredicates.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectPredicates peekDirectPredicates(int r) {
        IdContainerHashMap idContainerHashMap = this.directPredicatesMap;
        synchronized (idContainerHashMap) {
            return (DirectPredicates)this.directPredicatesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Predicates getOrCreatePredicates(ReadGraphImpl graph, int r) throws DatabaseException {
        Predicates existing = null;
        IdContainerHashMap idContainerHashMap = this.predicatesMap;
        synchronized (idContainerHashMap) {
            existing = (Predicates)this.predicatesMap.get(r);
            if (existing == null) {
                existing = new Predicates(r);
                existing.setPending(this.querySupport);
                this.predicatesMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Predicates entry) {
        IdContainerHashMap idContainerHashMap = this.predicatesMap;
        synchronized (idContainerHashMap) {
            this.predicatesMap.remove(entry.id);
        }
    }

    public static void runnerPredicates(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        InternalProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            Predicates e = cache.peekPredicates(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            Predicates.computeForEach(graph, r, null, procedure);
            return;
        }
        Predicates entry = cache.getOrCreatePredicates(graph, r);
        InternalProcedure internalProcedure = procedure_ = procedure != null ? procedure : emptyProcedurePredicates;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            Predicates.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Predicates peekPredicates(int r) {
        IdContainerHashMap idContainerHashMap = this.predicatesMap;
        synchronized (idContainerHashMap) {
            return (Predicates)this.predicatesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Types getOrCreateTypes(ReadGraphImpl graph, int r) throws DatabaseException {
        Types existing = null;
        IdContainerHashMap idContainerHashMap = this.typesMap;
        synchronized (idContainerHashMap) {
            existing = (Types)this.typesMap.get(r);
            if (existing == null) {
                existing = new Types(r);
                existing.setPending(this.querySupport);
                this.typesMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Types entry) {
        IdContainerHashMap idContainerHashMap = this.typesMap;
        synchronized (idContainerHashMap) {
            this.typesMap.remove(entry.id);
        }
    }

    public static void runnerTypes(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        InternalProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            Types e = cache.peekTypes(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            Types.computeForEach(graph, r, null, procedure);
            return;
        }
        Types entry = cache.getOrCreateTypes(graph, r);
        InternalProcedure internalProcedure = procedure_ = procedure != null ? procedure : emptyProcedureTypes;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            Types.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Types peekTypes(int r) {
        IdContainerHashMap idContainerHashMap = this.typesMap;
        synchronized (idContainerHashMap) {
            return (Types)this.typesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChildMap getOrCreateChildMap(ReadGraphImpl graph, int r) throws DatabaseException {
        ChildMap existing = null;
        IdContainerHashMap idContainerHashMap = this.childMapMap;
        synchronized (idContainerHashMap) {
            existing = (ChildMap)this.childMapMap.get(r);
            if (existing == null) {
                existing = new ChildMap(r);
                existing.setPending(this.querySupport);
                this.childMapMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ChildMap entry) {
        IdContainerHashMap idContainerHashMap = this.childMapMap;
        synchronized (idContainerHashMap) {
            this.childMapMap.remove(entry.id);
        }
    }

    public static void runnerChildMap(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, InternalProcedure<ObjectResourceIdMap<String>> procedure) throws DatabaseException {
        InternalProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            ChildMap e = cache.peekChildMap(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            ChildMap.computeForEach(graph, r, null, procedure);
            return;
        }
        ChildMap entry = cache.getOrCreateChildMap(graph, r);
        InternalProcedure internalProcedure = procedure_ = procedure != null ? procedure : emptyProcedureChildMap;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            ChildMap.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChildMap peekChildMap(int r) {
        IdContainerHashMap idContainerHashMap = this.childMapMap;
        synchronized (idContainerHashMap) {
            return (ChildMap)this.childMapMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeHierarchy getOrCreateTypeHierarchy(ReadGraphImpl graph, int r) throws DatabaseException {
        TypeHierarchy existing = null;
        IdContainerHashMap idContainerHashMap = this.typeHierarchyMap;
        synchronized (idContainerHashMap) {
            existing = (TypeHierarchy)this.typeHierarchyMap.get(r);
            if (existing == null) {
                existing = new TypeHierarchy(r);
                existing.setPending(this.querySupport);
                this.typeHierarchyMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(TypeHierarchy entry) {
        IdContainerHashMap idContainerHashMap = this.typeHierarchyMap;
        synchronized (idContainerHashMap) {
            this.typeHierarchyMap.remove(entry.id);
        }
    }

    public static void runnerTypeHierarchy(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        InternalProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            TypeHierarchy e = cache.peekTypeHierarchy(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            TypeHierarchy.computeForEach(graph, r, null, procedure);
            return;
        }
        TypeHierarchy entry = cache.getOrCreateTypeHierarchy(graph, r);
        InternalProcedure internalProcedure = procedure_ = procedure != null ? procedure : emptyProcedureTypeHierarchy;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            TypeHierarchy.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeHierarchy peekTypeHierarchy(int r) {
        IdContainerHashMap idContainerHashMap = this.typeHierarchyMap;
        synchronized (idContainerHashMap) {
            return (TypeHierarchy)this.typeHierarchyMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SuperTypes getOrCreateSuperTypes(ReadGraphImpl graph, int r) throws DatabaseException {
        SuperTypes existing = null;
        IdContainerHashMap idContainerHashMap = this.superTypesMap;
        synchronized (idContainerHashMap) {
            existing = (SuperTypes)this.superTypesMap.get(r);
            if (existing == null) {
                existing = new SuperTypes(r);
                existing.setPending(this.querySupport);
                this.superTypesMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(SuperTypes entry) {
        IdContainerHashMap idContainerHashMap = this.superTypesMap;
        synchronized (idContainerHashMap) {
            this.superTypesMap.remove(entry.id);
        }
    }

    public static void runnerSuperTypes(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        InternalProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            SuperTypes e = cache.peekSuperTypes(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            SuperTypes.computeForEach(graph, r, null, procedure);
            return;
        }
        SuperTypes entry = cache.getOrCreateSuperTypes(graph, r);
        InternalProcedure internalProcedure = procedure_ = procedure != null ? procedure : emptyProcedureSuperTypes;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            SuperTypes.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SuperTypes peekSuperTypes(int r) {
        IdContainerHashMap idContainerHashMap = this.superTypesMap;
        synchronized (idContainerHashMap) {
            return (SuperTypes)this.superTypesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SuperRelations getOrCreateSuperRelations(ReadGraphImpl graph, int r) throws DatabaseException {
        SuperRelations existing = null;
        IdContainerHashMap idContainerHashMap = this.superRelationsMap;
        synchronized (idContainerHashMap) {
            existing = (SuperRelations)this.superRelationsMap.get(r);
            if (existing == null) {
                existing = new SuperRelations(r);
                existing.setPending(this.querySupport);
                this.superRelationsMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(SuperRelations entry) {
        IdContainerHashMap idContainerHashMap = this.superRelationsMap;
        synchronized (idContainerHashMap) {
            this.superRelationsMap.remove(entry.id);
        }
    }

    public static void runnerSuperRelations(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, InternalProcedure<IntSet> procedure) throws DatabaseException {
        InternalProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        if (parent == null && listener == null && !QueryCache.shouldCache(graph, r)) {
            SuperRelations e = cache.peekSuperRelations(r);
            if (e != null && e.isReady()) {
                e.performFromCache(graph, procedure);
                return;
            }
            SuperRelations.computeForEach(graph, r, null, procedure);
            return;
        }
        SuperRelations entry = cache.getOrCreateSuperRelations(graph, r);
        InternalProcedure internalProcedure = procedure_ = procedure != null ? procedure : emptyProcedureSuperRelations;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            SuperRelations.computeForEach(graph, r, entry, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SuperRelations peekSuperRelations(int r) {
        IdContainerHashMap idContainerHashMap = this.superRelationsMap;
        synchronized (idContainerHashMap) {
            return (SuperRelations)this.superRelationsMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AssertedPredicates getOrCreateAssertedPredicates(ReadGraphImpl graph, int r) throws DatabaseException {
        AssertedPredicates existing = null;
        IdContainerHashMap idContainerHashMap = this.assertedPredicatesMap;
        synchronized (idContainerHashMap) {
            existing = (AssertedPredicates)this.assertedPredicatesMap.get(r);
            if (existing == null) {
                existing = new AssertedPredicates(r);
                existing.setPending(this.querySupport);
                this.assertedPredicatesMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(AssertedPredicates entry) {
        IdContainerHashMap idContainerHashMap = this.assertedPredicatesMap;
        synchronized (idContainerHashMap) {
            this.assertedPredicatesMap.remove(entry.id);
        }
    }

    public static void runnerAssertedPredicates(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        IntProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        AssertedPredicates entry = cache.getOrCreateAssertedPredicates(graph, r);
        IntProcedure intProcedure = procedure_ = procedure != null ? procedure : emptyProcedureAssertedPredicates;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.compute(graph, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssertedPredicates peekAssertedPredicates(int r) {
        IdContainerHashMap idContainerHashMap = this.assertedPredicatesMap;
        synchronized (idContainerHashMap) {
            return (AssertedPredicates)this.assertedPredicatesMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AssertedStatements getOrCreateAssertedStatements(ReadGraphImpl graph, int r1, int r2) throws DatabaseException {
        AssertedStatements existing = null;
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.assertedStatementsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            existing = (AssertedStatements)this.assertedStatementsMap.get(r1, r2);
            if (existing == null) {
                existing = new AssertedStatements(r1, r2);
                existing.setPending(this.querySupport);
                this.assertedStatementsMap.put(QueryCache.keyR2(r1, r2), (DualIdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(AssertedStatements entry) {
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.assertedStatementsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            this.assertedStatementsMap.remove(entry.id);
        }
    }

    public static void runnerAssertedStatements(ReadGraphImpl graph, int r1, int r2, CacheEntry<?> parent, ListenerBase listener, TripleIntProcedure procedure) throws DatabaseException {
        TripleIntProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        AssertedStatements entry = cache.getOrCreateAssertedStatements(graph, r1, r2);
        TripleIntProcedure tripleIntProcedure = procedure_ = procedure != null ? procedure : emptyProcedureAssertedStatements;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.compute(graph, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssertedStatements peekAssertedStatements(int r1, int r2) {
        DualIdContainerHashMapWithPrimaryIdLookup dualIdContainerHashMapWithPrimaryIdLookup = this.assertedStatementsMap;
        synchronized (dualIdContainerHashMapWithPrimaryIdLookup) {
            return (AssertedStatements)this.assertedStatementsMap.get(r1, r2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectSuperRelations getOrCreateDirectSuperRelations(ReadGraphImpl graph, int r) throws DatabaseException {
        DirectSuperRelations existing = null;
        IdContainerHashMap idContainerHashMap = this.directSuperRelationsMap;
        synchronized (idContainerHashMap) {
            existing = (DirectSuperRelations)this.directSuperRelationsMap.get(r);
            if (existing == null) {
                existing = new DirectSuperRelations(r);
                existing.setPending(this.querySupport);
                this.directSuperRelationsMap.put(QueryCache.keyR(r), (IdContainer)existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(DirectSuperRelations entry) {
        IdContainerHashMap idContainerHashMap = this.directSuperRelationsMap;
        synchronized (idContainerHashMap) {
            this.directSuperRelationsMap.remove(entry.id);
        }
    }

    public static void runnerDirectSuperRelations(ReadGraphImpl graph, int r, CacheEntry<?> parent, ListenerBase listener, IntProcedure procedure) throws DatabaseException {
        IntProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        DirectSuperRelations entry = cache.getOrCreateDirectSuperRelations(graph, r);
        IntProcedure intProcedure = procedure_ = procedure != null ? procedure : emptyProcedureDirectSuperRelations;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.compute(graph, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectSuperRelations peekDirectSuperRelations(int r) {
        IdContainerHashMap idContainerHashMap = this.directSuperRelationsMap;
        synchronized (idContainerHashMap) {
            return (DirectSuperRelations)this.directSuperRelationsMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiReadEntry getOrCreateMultiReadEntry(ReadGraphImpl graph, MultiRead<?> r) throws DatabaseException {
        MultiReadEntry existing = null;
        StableHashMap stableHashMap = this.multiReadEntryMap;
        synchronized (stableHashMap) {
            existing = (MultiReadEntry)this.multiReadEntryMap.get(r);
            if (existing == null) {
                existing = new MultiReadEntry(r);
                existing.setPending(this.querySupport);
                this.multiReadEntryMap.put(QueryCache.id(r), existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(MultiReadEntry entry) {
        StableHashMap stableHashMap = this.multiReadEntryMap;
        synchronized (stableHashMap) {
            this.multiReadEntryMap.remove(entry.id);
        }
    }

    public static void runnerMultiReadEntry(ReadGraphImpl graph, MultiRead<?> r, CacheEntry<?> parent, ListenerBase listener, SyncMultiProcedure procedure) throws DatabaseException {
        SyncMultiProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        MultiReadEntry entry = cache.getOrCreateMultiReadEntry(graph, r);
        SyncMultiProcedure syncMultiProcedure = procedure_ = procedure != null ? procedure : emptyProcedureMultiReadEntry;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.compute(graph, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiReadEntry peekMultiReadEntry(MultiRead<?> r) {
        StableHashMap stableHashMap = this.multiReadEntryMap;
        synchronized (stableHashMap) {
            return (MultiReadEntry)this.multiReadEntryMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsyncMultiReadEntry getOrCreateAsyncMultiReadEntry(ReadGraphImpl graph, AsyncMultiRead<?> r) throws DatabaseException {
        AsyncMultiReadEntry existing = null;
        StableHashMap stableHashMap = this.asyncMultiReadEntryMap;
        synchronized (stableHashMap) {
            existing = (AsyncMultiReadEntry)this.asyncMultiReadEntryMap.get(r);
            if (existing == null) {
                existing = new AsyncMultiReadEntry(r);
                existing.setPending(this.querySupport);
                this.asyncMultiReadEntryMap.put(QueryCache.id(r), existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(AsyncMultiReadEntry entry) {
        StableHashMap stableHashMap = this.asyncMultiReadEntryMap;
        synchronized (stableHashMap) {
            this.asyncMultiReadEntryMap.remove(entry.id);
        }
    }

    public static void runnerAsyncMultiReadEntry(ReadGraphImpl graph, AsyncMultiRead<?> r, CacheEntry<?> parent, ListenerBase listener, AsyncMultiProcedure procedure) throws DatabaseException {
        AsyncMultiProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        AsyncMultiReadEntry entry = cache.getOrCreateAsyncMultiReadEntry(graph, r);
        AsyncMultiProcedure asyncMultiProcedure = procedure_ = procedure != null ? procedure : emptyProcedureAsyncMultiReadEntry;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.compute(graph, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncMultiReadEntry peekAsyncMultiReadEntry(AsyncMultiRead<?> r) {
        StableHashMap stableHashMap = this.asyncMultiReadEntryMap;
        synchronized (stableHashMap) {
            return (AsyncMultiReadEntry)this.asyncMultiReadEntryMap.get(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExternalReadEntry getOrCreateExternalReadEntry(ReadGraphImpl graph, ExternalRead<?> r) throws DatabaseException {
        ExternalReadEntry existing = null;
        StableHashMap stableHashMap = this.externalReadEntryMap;
        synchronized (stableHashMap) {
            existing = (ExternalReadEntry)this.externalReadEntryMap.get(r);
            if (existing == null) {
                existing = new ExternalReadEntry(r, graph);
                existing.setPending(this.querySupport);
                this.externalReadEntryMap.put(QueryCache.id(r), existing);
                ++this.updates;
                ++this.size;
                return existing;
            }
            if (existing.requiresComputation()) {
                existing.setPending(this.querySupport);
                return existing;
            }
        }
        if (existing.isPending()) {
            QueryCache.waitPending(graph, existing);
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ExternalReadEntry entry) {
        StableHashMap stableHashMap = this.externalReadEntryMap;
        synchronized (stableHashMap) {
            this.externalReadEntryMap.remove(entry.id);
        }
    }

    public static void runnerExternalReadEntry(ReadGraphImpl graph, ExternalRead<?> r, CacheEntry<?> parent, ListenerBase listener, AsyncProcedure procedure) throws DatabaseException {
        AsyncProcedure procedure_;
        QueryCache cache = graph.processor.cache;
        ExternalReadEntry entry = cache.getOrCreateExternalReadEntry(graph, r);
        AsyncProcedure asyncProcedure = procedure_ = procedure != null ? procedure : emptyProcedureExternalReadEntry;
        if (entry.isReady()) {
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.performFromCache(graph, procedure_);
        } else {
            assert (entry.isPending());
            graph.processor.listening.registerDependencies(graph, entry, parent, listener, procedure_, false);
            entry.compute(graph, procedure_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalReadEntry peekExternalReadEntry(ExternalRead<?> r) {
        StableHashMap stableHashMap = this.externalReadEntryMap;
        synchronized (stableHashMap) {
            return (ExternalReadEntry)this.externalReadEntryMap.get(r);
        }
    }
}

