/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.common.utils.InvalidOrderedSetException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CollectionUnaryQuery;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryProcessor;

public final class OrderedSet
extends CollectionUnaryQuery {
    public OrderedSet(int r) {
        super(r);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    private static int nextElement(ReadGraphImpl graph, int current, final int orderedSet, OrderedSet parent, final IntProcedure procedure) throws DatabaseException {
        QueryProcessor processor = graph.processor;
        processor.querySupport.ensureLoaded(graph, current);
        final AtomicInteger res = new AtomicInteger(0);
        processor.querySupport.getObjects(graph, current, orderedSet, new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                if (i != orderedSet) {
                    procedure.execute(graph, i);
                }
                res.set(i);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                procedure.exception(graph, t);
                res.set(-1);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }
        });
        int r = res.get();
        if (r == orderedSet) {
            procedure.finished(graph);
        } else if (r == 0) {
            procedure.exception(graph, (Throwable)new InvalidOrderedSetException("Invalid ordered set (" + orderedSet + ") element: " + current + ", 0 successors."));
        }
        return r;
    }

    @Override
    public void compute(ReadGraphImpl graph, IntProcedure procedure) throws DatabaseException {
        OrderedSet.computeForEach(graph, this.id, this, procedure);
    }

    static void computeForEach(ReadGraphImpl graph, int orderedSet, OrderedSet entry, IntProcedure procedure_) throws DatabaseException {
        IntProcedure procedure = entry != null ? entry : procedure_;
        int current = OrderedSet.nextElement(graph, orderedSet, orderedSet, entry, procedure);
        while (current != 0 && current != -1 && current != orderedSet) {
            current = OrderedSet.nextElement(graph, current, orderedSet, entry, procedure);
        }
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
    }

    public String toString() {
        return "OrderedSet[" + this.id + "]";
    }
}

