/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.RelationInfo;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.procedure.TripleIntProcedureAdapter;
import org.simantics.db.impl.query.CollectionBinaryQuery;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.TripleIntProcedure;

public final class AssertedStatements
extends CollectionBinaryQuery<TripleIntProcedure> {
    public AssertedStatements(int r1, int r2) {
        super(r1, r2);
    }

    public static AssertedStatements newInstance(int r1, int r2) {
        return new AssertedStatements(r1, r2);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    static void computeInheritedAssertions(ReadGraphImpl graph, int type, final int predicate, RelationInfo ri, final AssertedStatements entry, final TripleIntProcedure proc) throws DatabaseException {
        QueryProcessor processor = graph.processor;
        QueryCache.runnerDirectObjects(graph, type, processor.getInherits(), entry, null, new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
                AssertedStatements.finish(graph, entry);
                proc.finished(graph);
            }

            @Override
            public void execute(ReadGraphImpl graph, int inh) throws DatabaseException {
                this.inc();
                QueryCache.runnerAssertedStatements(graph, inh, predicate, entry, null, new TripleIntProcedureAdapter(){

                    @Override
                    public void execute(ReadGraphImpl graph, int s, int p, int o) throws DatabaseException {
                        if (AssertedStatements.addOrSet(s, p, o, entry)) {
                            proc.execute(graph, s, p, o);
                        }
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) throws DatabaseException {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        proc.exception(graph, t);
                        this.dec(graph);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                this.dec(graph);
            }
        });
    }

    static void computeLocalAssertions(ReadGraphImpl graph, int type, int predicate, RelationInfo ri, AssertedStatements entry, TripleIntProcedure proc) throws DatabaseException {
    }

    public Object compute(ReadGraphImpl graph, TripleIntProcedure procedure) throws DatabaseException {
        AssertedStatements.computeForEach(graph, this.r1(), this.r2(), this, procedure);
        return this.getResult();
    }

    public static void computeForEach(ReadGraphImpl graph, final int type, final int predicate, final AssertedStatements entry, final TripleIntProcedure procedure) throws DatabaseException {
        final RelationInfo ri = QueryCache.resultRelationInfoQuery(graph, predicate, entry, null);
        final AtomicInteger found = new AtomicInteger(0);
        final QueryProcessor processor = graph.processor;
        QueryCache.runnerDirectObjects(graph, type, processor.getAsserts(), entry, null, new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
                if (ri.isFunctional && found.get() > 1) {
                    ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one asserted statement.");
                    AssertedStatements.except((Throwable)exception, entry);
                    procedure.exception(graph, (Throwable)exception);
                    return;
                }
                if (ri.isFunctional && found.get() == 1) {
                    AssertedStatements.finish(graph, entry);
                    procedure.finished(graph);
                    return;
                }
                AssertedStatements.computeInheritedAssertions(graph, type, predicate, ri, entry, procedure);
            }

            @Override
            public void execute(ReadGraphImpl graph, final int ass) throws DatabaseException {
                if (ri.isFunctional && found.get() > 1) {
                    return;
                }
                this.inc();
                QueryCache.runnerDirectObjects(graph, ass, processor.getHasPredicate(), entry, null, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, final int pred) throws DatabaseException {
                        if (ri.isFunctional) {
                            if (found.get() > 1) {
                                return;
                            }
                            this.inc();
                            QueryCache.runnerDirectObjects(graph, ass, processor.getHasObject(), entry, null, new IntProcedure(){

                                @Override
                                public void execute(ReadGraphImpl graph, final int object) throws DatabaseException {
                                    if (found.get() > 1) {
                                        return;
                                    }
                                    if (pred == predicate) {
                                        if (found.getAndIncrement() == 0 && AssertedStatements.addOrSet(type, pred, object, entry)) {
                                            procedure.execute(graph, type, pred, object);
                                        }
                                        return;
                                    }
                                    if (!ri.isFinal) {
                                        this.inc();
                                        QueryCache.runnerSuperRelations(graph, pred, entry, null, new InternalProcedure<IntSet>(){

                                            @Override
                                            public void execute(ReadGraphImpl graph, IntSet result) throws DatabaseException {
                                                if (found.get() > 1) {
                                                    this.dec(graph);
                                                    return;
                                                }
                                                if (result.contains(predicate) && found.getAndIncrement() == 0 && AssertedStatements.addOrSet(type, pred, object, entry)) {
                                                    procedure.execute(graph, type, pred, object);
                                                }
                                                this.dec(graph);
                                            }

                                            @Override
                                            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                                procedure.exception(graph, t);
                                                this.dec(graph);
                                            }
                                        });
                                    }
                                }

                                @Override
                                public void finished(ReadGraphImpl graph) throws DatabaseException {
                                    this.dec(graph);
                                }

                                @Override
                                public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                    procedure.exception(graph, t);
                                    this.dec(graph);
                                }
                            });
                        } else {
                            this.inc();
                            QueryCache.runnerDirectObjects(graph, ass, processor.getHasObject(), entry, null, new IntProcedure(){

                                @Override
                                public void execute(ReadGraphImpl graph, final int object) throws DatabaseException {
                                    if (pred == predicate) {
                                        AssertedStatements.addOrSet(type, pred, object, entry);
                                        procedure.execute(graph, type, pred, object);
                                        return;
                                    }
                                    if (!ri.isFinal) {
                                        this.inc();
                                        QueryCache.runnerSuperRelations(graph, pred, entry, null, new InternalProcedure<IntSet>(){

                                            @Override
                                            public void execute(ReadGraphImpl graph, IntSet result) throws DatabaseException {
                                                if (result.contains(predicate)) {
                                                    AssertedStatements.addOrSet(type, pred, object, entry);
                                                    procedure.execute(graph, type, pred, object);
                                                }
                                                this.dec(graph);
                                            }

                                            @Override
                                            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                                procedure.exception(graph, t);
                                                this.dec(graph);
                                            }
                                        });
                                    }
                                }

                                @Override
                                public void finished(ReadGraphImpl graph) throws DatabaseException {
                                    this.dec(graph);
                                }

                                @Override
                                public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                    procedure.exception(graph, t);
                                    this.dec(graph);
                                }
                            });
                        }
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) throws DatabaseException {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        procedure.exception(graph, t);
                        this.dec(graph);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                this.dec(graph);
            }
        });
    }

    public String toString() {
        return "AssertedStatements[" + this.r1() + " - " + this.r2() + "]";
    }

    private boolean addOrSet(int s, int p, int o) {
        assert (this.isPending());
        IntArray value = (IntArray)this.getResult();
        if (value.data != null) {
            int i = 0;
            while (i < value.sizeOrData) {
                int existingO;
                int existingP = value.data[i + 1];
                if (p == existingP && (existingO = value.data[i + 2]) == o) {
                    return false;
                }
                i += 3;
            }
            value.add(s);
            value.add(p);
            value.add(o);
        } else {
            value.add(s);
            value.add(p);
            value.add(o);
        }
        return true;
    }

    static boolean addOrSet(int s, int p, int o, AssertedStatements entry) {
        if (entry != null) {
            return entry.addOrSet(s, p, o);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void finish(ReadGraphImpl graph, AssertedStatements entry) {
        assert (entry.isPending());
        if (entry != null) {
            AssertedStatements assertedStatements = entry;
            synchronized (assertedStatements) {
                entry.setReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void except(Throwable t, AssertedStatements entry) {
        if (entry != null) {
            AssertedStatements assertedStatements = entry;
            synchronized (assertedStatements) {
                entry.except(t);
            }
        }
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, TripleIntProcedure procedure) throws DatabaseException {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return this.getResult();
        }
        IntArray value = (IntArray)this.getResult();
        int i = 0;
        while (i < value.size()) {
            procedure.execute(graph, value.data[i], value.data[i + 1], value.data[i + 2]);
            i += 3;
        }
        procedure.finished(graph);
        return value;
    }

    @Override
    public void recompute(ReadGraphImpl graph) throws DatabaseException {
        this.compute(graph, new TripleIntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Error in recompute", t);
            }
        });
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutableForReading(this.r1());
    }
}

