/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.procedure;

import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Procedure;

public class ResultCallWrappedSingleQueryProcedure45<Result>
implements AsyncProcedure<Result> {
    private Result result = null;
    private Throwable exception = null;
    private final Procedure<Result> procedure;
    private final QueryProcessor.AsyncBarrier barrier;
    private final AtomicBoolean latch;

    public ResultCallWrappedSingleQueryProcedure45(Procedure<Result> procedure, QueryProcessor.AsyncBarrier barrier) {
        assert (procedure != null);
        this.procedure = procedure;
        this.barrier = barrier;
        this.latch = new AtomicBoolean(false);
    }

    public void execute(AsyncReadGraph graph, Result result) {
        this.result = result;
        if (this.latch.compareAndSet(false, true)) {
            try {
                try {
                    this.procedure.execute(result);
                }
                catch (Throwable throwable) {
                    Logger.defaultLogError((String)("AsyncProcedure.execute threw for " + String.valueOf(this.procedure)), (Throwable)throwable);
                    this.barrier.dec();
                }
            }
            finally {
                this.barrier.dec();
            }
        } else {
            Logger.defaultLogError((String)"Procedure was called many times (this time is execute)");
        }
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        this.exception = t;
        if (this.latch.compareAndSet(false, true)) {
            try {
                try {
                    this.procedure.exception(t);
                }
                catch (Throwable throwable) {
                    Logger.defaultLogError((String)("AsyncProcedure.exception threw for " + String.valueOf(this.procedure)), (Throwable)throwable);
                    this.barrier.dec();
                }
            }
            finally {
                this.barrier.dec();
            }
        } else {
            Logger.defaultLogError((String)"Procedure was called many times (this time is exception)");
        }
    }

    public Result getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }
}

