/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.MetadataUtils;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.ClusterSetExistException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.PassthroughSerializerBinding;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.request.WriteResult;
import org.simantics.db.request.WriteTraits;
import org.simantics.db.service.ByteReader;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.TransferableGraphSupport;
import org.simantics.graph.utils.TGResourceUtil;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedWriteGraph
extends ReadGraphImpl
implements WriteGraph,
ByteReader,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayedWriteGraph.class);
    private static final boolean DEBUG = false;
    private static final int BUFFER_SIZE = 524288;
    private static final PassthroughSerializerBinding PASSTHROUGH = new PassthroughSerializerBinding();
    private final int TERM = 0;
    private final int CLAIM = 1;
    private final int CLAIM_NOINVERSE = 2;
    private final int CLAIM_VALUE_B = 4;
    private final int DENY = 5;
    private final int DENY_VALUE = 6;
    private final int COMMIT_AND_CONTINUE = 7;
    private State writeState;
    private TreeMap<String, byte[]> metadata = new TreeMap();
    private FileChannel channel;
    private byte[] bytes = new byte[524288];
    private ByteBuffer bb = ByteBuffer.wrap(this.bytes);
    private int byteIndex = 0;
    private Layer0 b;
    private Session session;
    private OutputStream valueWriter = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
            DelayedWriteGraph.this.writeByte(b);
        }
    };
    private TGResourceUtil util = new TGResourceUtil();
    private TIntObjectHashMap<Datatype> resourceValues = new TIntObjectHashMap(10, 0.5f, -1);

    public static Resource convertDelayedResource(Resource r) {
        if (r instanceof InternalResource) {
            return ((InternalResource)r).resource;
        }
        return r;
    }

    private int getId(Resource resource) {
        if (resource instanceof InternalResource) {
            return ((InternalResource)resource).id;
        }
        ResourceImpl r = (ResourceImpl)resource;
        int id = this.writeState.externalToId.get(r.id);
        if (id != -1) {
            return id;
        }
        id = this.writeState.idToResource.size();
        this.writeState.idToResource.add(resource);
        this.writeState.externalToId.put(r.id, id);
        return id;
    }

    private Resource getResource(int id) {
        return this.writeState.idToResource.get(id);
    }

    private int getBindingId(Binding binding) {
        if (this.writeState.bindingToId.contains((Object)binding)) {
            return this.writeState.bindingToId.get((Object)binding);
        }
        int id = this.writeState.idToBinding.size();
        this.writeState.idToBinding.add(binding);
        this.writeState.bindingToId.put((Object)binding, id);
        return id;
    }

    public DelayedWriteGraph(ReadGraph g) throws IOException {
        super((ReadGraphImpl)g);
        this.writeState = new State();
        this.session = g.getSession();
        this.b = Layer0.getInstance((ReadGraph)g);
        this.writeState.defaultCluster = this.newCluster();
    }

    public DelayedWriteGraph(ReadGraph g, State state) {
        super((ReadGraphImpl)g);
        this.session = g.getSession();
        this.b = Layer0.getInstance((ReadGraph)g);
        this.writeState = state;
    }

    public DelayedWriteGraph newSync() {
        return new DelayedWriteGraph((ReadGraph)this, this.writeState);
    }

    public void claim(Resource subject, Resource predicate, Resource object) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        Resource inverse = this.getPossibleInverse(predicate);
        this.claim(subject, predicate, inverse, object);
    }

    public void addLiteral(Resource resource, Resource predicate, Resource inverse, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        Resource valueResource = this.newResource();
        this.claimValue(valueResource, value, binding);
        this.claim(valueResource, this.b.InstanceOf, null, type);
        this.claim(resource, predicate, inverse, valueResource);
    }

    public void addLiteral(Resource resource, Resource predicate, Resource inverse, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        Resource type = this.getType(value);
        if (type == null) {
            Resource literal = this.newResource();
            type = this.b.Literal;
            Resource dataType = this.newResource();
            this.claim(dataType, this.b.InstanceOf, null, this.b.DataType);
            this.claimValue(dataType, binding.type(), DATA_TYPE_BINDING_INTERNAL);
            this.claim(literal, this.b.HasDataType, null, dataType);
            this.claim(literal, this.b.InstanceOf, null, type);
            this.claimValue(literal, value, binding);
            this.claim(resource, predicate, inverse, literal);
        } else {
            this.addLiteral(resource, predicate, inverse, type, value, binding);
        }
    }

    public <T extends Accessor> T newLiteral(Resource resource, Resource predicate, Datatype datatype, Object initialValue) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public RandomAccessBinary createRandomAccessBinary(Resource resource, Resource predicate, Datatype datatype, Object initialValue) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RandomAccessBinary createRandomAccessBinary(Resource resource, Datatype datatype, Object initialValue) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public void claimLiteral(Resource resource, Resource predicate, Object value) throws ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Binding b = Bindings.getBinding(value.getClass());
            this.claimLiteral(resource, predicate, value, b);
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
        catch (BindingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        Statement valueStatement = null;
        if (!(resource instanceof InternalResource)) {
            valueStatement = this.getPossibleStatement(resource, predicate);
        }
        if (valueStatement != null && resource.equals(valueStatement.getSubject())) {
            this.claimValue(valueStatement.getObject(), value, binding);
        } else {
            Resource type = this.getType(value);
            Resource literal = this.newResource();
            if (type == null) {
                type = this.b.Literal;
                Resource dataType = this.newResource();
                this.claim(dataType, this.b.InstanceOf, null, this.b.DataType);
                this.claimValue(dataType, binding.type(), DATA_TYPE_BINDING_INTERNAL);
                this.claim(literal, this.b.HasDataType, dataType);
            }
            this.claim(literal, this.b.InstanceOf, null, type);
            this.claimValue(literal, value, binding);
            this.claim(resource, predicate, literal);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource inverse, Resource type, Object value) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Binding b = Bindings.getBinding(value.getClass());
            this.claimLiteral(resource, predicate, inverse, type, value, b);
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
        catch (BindingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource inverse, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        Statement valueStatement;
        Statement statement = valueStatement = resource instanceof InternalResource ? null : this.getPossibleStatement(resource, predicate);
        if (valueStatement != null && resource.equals(valueStatement.getSubject())) {
            this.claimValue(valueStatement.getObject(), value, binding);
        } else {
            Resource valueResource = this.newResource();
            this.claim(valueResource, this.b.InstanceOf, null, type);
            this.claim(resource, predicate, inverse, valueResource);
            this.claimValue(valueResource, value, binding);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource type, Object value) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Binding b = Bindings.getBinding(value.getClass());
            this.claimLiteral(resource, predicate, type, value, b);
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
        catch (BindingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Resource inverse = this.getSingleObject(predicate, this.b.InverseOf);
            this.claimLiteral(resource, predicate, inverse, type, value, binding);
        }
        catch (NoSingleResultException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void deny(Resource subject) throws ServiceException {
        assert (subject != null);
        if (!(subject instanceof InternalResource)) {
            try {
                for (Statement statement : this.getStatements(subject, this.b.IsWeaklyRelatedTo)) {
                    this.deny(statement);
                }
            }
            catch (ManyObjectsForFunctionalRelationException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    public void deny(Resource subject, Resource predicate) throws ServiceException {
        assert (subject != null);
        if (!(subject instanceof InternalResource)) {
            for (Resource object : this.getObjects(subject, predicate)) {
                this.deny(subject, predicate, object);
            }
        }
    }

    public void deny(Resource subject, Resource predicate, Resource object) throws ServiceException {
        this.denyStatement(subject, predicate, object);
    }

    public void denyStatement(Resource subject, Resource predicate, Resource object) throws ServiceException {
        this.deny(subject, predicate, this.getPossibleInverse(predicate), object);
    }

    public void deny(Statement statement) throws ServiceException {
        Resource predicate = statement.getPredicate();
        this.deny(statement.getSubject(), predicate, this.getPossibleInverse(predicate), statement.getObject());
    }

    public void denyValue(Resource resource, Resource predicate) throws ManyObjectsForFunctionalRelationException, ServiceException {
        Statement valueStatement;
        assert (resource != null);
        assert (predicate != null);
        if (!(resource instanceof InternalResource) && (valueStatement = this.getPossibleStatement(resource, predicate)) != null && !valueStatement.isAsserted(resource)) {
            Resource value = valueStatement.getObject();
            this.deny(valueStatement);
            this.denyValue(value);
        }
    }

    public Resource newResource() throws ServiceException {
        if (this.writeState.defaultClusterSet != null) {
            return this.newResource(this.writeState.defaultClusterSet);
        }
        return this.newResource(this.writeState.defaultCluster);
    }

    public Resource newResource(long clusterId) throws ServiceException {
        int id = this.writeState.idToResource.size();
        InternalResource ret = new InternalResource(id, clusterId);
        this.writeState.idToResource.add(ret);
        return ret;
    }

    public Resource newResource(Resource clusterSet) throws ServiceException {
        WriteSupport ws;
        if (clusterSet instanceof InternalResource ? !this.writeState.clusterSets.contains(clusterSet) : !(ws = (WriteSupport)this.session.getService(WriteSupport.class)).hasClusterSet(null, clusterSet) && !this.writeState.clusterSetsForExistingResources.contains(clusterSet)) {
            throw new ClusterSetExistException("Cluster set does not exist. Resource=" + String.valueOf(clusterSet));
        }
        int id = this.writeState.idToResource.size();
        InternalResource ret = new InternalResource(id, clusterSet);
        this.writeState.idToResource.add(ret);
        return ret;
    }

    public void newClusterSet(Resource clusterSet) throws ServiceException {
        boolean existingResource;
        boolean bl = existingResource = !(clusterSet instanceof InternalResource);
        if (existingResource) {
            WriteSupport ws = (WriteSupport)this.session.getService(WriteSupport.class);
            if (ws.hasClusterSet(null, clusterSet)) {
                throw new ClusterSetExistException("Cluster set exist already. Resource=" + String.valueOf(clusterSet));
            }
            this.writeState.clusterSetsForExistingResources.add(clusterSet);
        } else if (!this.writeState.clusterSets.add(clusterSet)) {
            throw new ClusterSetExistException("Cluster set exist already. Resource=" + String.valueOf(clusterSet));
        }
    }

    public Resource setClusterSet4NewResource(Resource clusterSet) throws ServiceException {
        Resource existing = this.writeState.defaultClusterSet;
        this.writeState.defaultClusterSet = clusterSet;
        return existing;
    }

    public void claim(Resource subject, Resource predicate, Resource inverse, Resource object) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        try {
            if (!(inverse == null || subject.equals(object) && inverse.equals(predicate))) {
                this.writeByte(1);
                this.writeInt(this.getId(subject));
                this.writeInt(this.getId(predicate));
                this.writeInt(this.getId(inverse));
                this.writeInt(this.getId(object));
            } else {
                this.writeByte(2);
                this.writeInt(this.getId(subject));
                this.writeInt(this.getId(predicate));
                this.writeInt(this.getId(object));
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void deny(Resource subject, Resource predicate, Resource inverse, Resource object) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        try {
            this.writeByte(5);
            this.writeInt(this.getId(subject));
            this.writeInt(this.getId(predicate));
            if (inverse != null) {
                this.writeInt(this.getId(inverse));
            } else {
                this.writeInt(0);
            }
            this.writeInt(this.getId(object));
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void deny(Resource subject, Resource predicate, Resource inverse, Resource object, VirtualGraph graph) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    public void claimValue(Resource resource, Object value) throws ServiceException {
        try {
            Binding binding = Bindings.getBinding(value.getClass());
            this.claimValue(resource, value, binding);
        }
        catch (BindingConstructionException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void claimValue(Resource resource, Object value, Binding binding) throws ServiceException {
        try {
            int rid = this.getId(resource);
            this.writeByte(4);
            this.writeInt(rid);
            Serializer serializer = binding.serializer();
            int size = serializer.getSize(value);
            this.writeInt(size);
            serializer.serialize(this.valueWriter, value);
            if (this.util.mayHaveResource(binding.type())) {
                this.resourceValues.put(rid, (Object)binding.type());
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to serialize claimed value ({}, {}, {})", new Object[]{resource, value, binding, e});
            throw new ServiceException((Throwable)e);
        }
    }

    public void denyValue(Resource resource) throws ServiceException {
        this.writeByte(6);
        this.writeInt(this.getId(resource));
    }

    public void denyValue(Resource resource, VirtualGraph graph) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    public void flushCluster() throws ServiceException {
        this.writeState.defaultCluster = this.newCluster();
    }

    public void flushCluster(Resource r) throws ServiceException {
        throw new ServiceException("Operation flushCluster(" + String.valueOf(r) + " not implemented.");
    }

    private void writeReset(int size) {
        this.byteIndex = 0;
        this.bb.position(0);
        this.bb.limit(size);
        try {
            if (this.writeState.tempFile == null) {
                File workspace = Platform.getLocation().toFile();
                File temp = new File(workspace, "tempFiles");
                File base = new File(temp, "delayed");
                Files.createDirectories(base.toPath(), new FileAttribute[0]);
                this.writeState.tempFile = new File(base, UUID.randomUUID().toString());
                this.writeState.out = new FileOutputStream(this.writeState.tempFile);
                this.channel = this.writeState.out.getChannel();
            }
            int got = 0;
            while (got < size) {
                int n = this.channel.write(this.bb);
                if (n <= 0) {
                    LOGGER.error("Failed to write buffer of {} bytes to temporary file {}", new Object[]{size, this.writeState.tempFile, new Exception("FileChannel.write returned " + n)});
                    return;
                }
                got += n;
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to write buffer of {} bytes to temporary file {}", new Object[]{size, this.writeState.tempFile, e});
        }
    }

    private void reset() {
        this.byteIndex = 0;
        this.bb.clear();
        if (this.channel != null) {
            try {
                int got = 0;
                while (got < 524288) {
                    int n = this.channel.read(this.bb);
                    if (n <= 0) {
                        return;
                    }
                    got += n;
                }
            }
            catch (IOException e) {
                LOGGER.error("FileChannel.read failed", (Throwable)e);
            }
        }
    }

    private void writeInt(int i) {
        if (this.byteIndex < 524284) {
            this.bytes[this.byteIndex++] = (byte)(i & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(i >>> 8 & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(i >>> 16 & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(i >>> 24 & 0xFF);
            if (this.byteIndex == 524288) {
                this.writeReset(524288);
            }
        } else {
            int has = 524288 - this.byteIndex;
            if (has == 0) {
                this.writeReset(524288);
            }
            this.bytes[this.byteIndex++] = (byte)(i & 0xFF);
            if (has == 1) {
                this.writeReset(524288);
            }
            this.bytes[this.byteIndex++] = (byte)(i >>> 8 & 0xFF);
            if (has == 2) {
                this.writeReset(524288);
            }
            this.bytes[this.byteIndex++] = (byte)(i >>> 16 & 0xFF);
            if (has == 3) {
                this.writeReset(524288);
            }
            this.bytes[this.byteIndex++] = (byte)(i >>> 24 & 0xFF);
            if (has == 4) {
                this.writeReset(524288);
            }
        }
    }

    private int readInt() {
        if (this.byteIndex < 524284) {
            int result = this.bytes[this.byteIndex++] & 0xFF | (this.bytes[this.byteIndex++] & 0xFF) << 8 | (this.bytes[this.byteIndex++] & 0xFF) << 16 | (this.bytes[this.byteIndex++] & 0xFF) << 24;
            return result;
        }
        int has = 524288 - this.byteIndex;
        int result = 0;
        if (has == 0) {
            this.reset();
        }
        result = this.bytes[this.byteIndex++] & 0xFF;
        if (has == 1) {
            this.reset();
        }
        result |= (this.bytes[this.byteIndex++] & 0xFF) << 8;
        if (has == 2) {
            this.reset();
        }
        result |= (this.bytes[this.byteIndex++] & 0xFF) << 16;
        if (has == 3) {
            this.reset();
        }
        result |= (this.bytes[this.byteIndex++] & 0xFF) << 24;
        if (has == 4) {
            this.reset();
        }
        return result;
    }

    private byte readByte() {
        byte result = this.bytes[this.byteIndex++];
        if (this.byteIndex == 524288) {
            this.reset();
        }
        return result;
    }

    private void writeByte(int b) {
        this.bytes[this.byteIndex++] = (byte)b;
        if (this.byteIndex == 524288) {
            this.writeReset(524288);
        }
    }

    private void writeBytes(byte[] data) {
        int has = 524288 - this.byteIndex;
        int amount = data.length;
        if (has > amount) {
            System.arraycopy(data, 0, this.bytes, this.byteIndex, amount);
            this.byteIndex += amount;
        } else {
            System.arraycopy(data, 0, this.bytes, this.byteIndex, has);
            this.writeReset(524288);
            ByteBuffer bb2 = ByteBuffer.wrap(data);
            bb2.position(has);
            try {
                this.channel.write(bb2);
            }
            catch (IOException e) {
                LOGGER.error("FileChannel.write failed", (Throwable)e);
            }
        }
    }

    public byte[] readBytes(byte[] result, int amount) {
        int has;
        if (result == null) {
            result = new byte[amount];
        }
        if ((has = 524288 - this.byteIndex) > amount) {
            System.arraycopy(this.bytes, this.byteIndex, result, 0, amount);
            this.byteIndex += amount;
        } else {
            System.arraycopy(this.bytes, this.byteIndex, result, 0, has);
            ByteBuffer bb2 = ByteBuffer.wrap(result);
            bb2.position(has);
            int got = has;
            while (got < amount) {
                try {
                    if ((got += this.channel.read(bb2)) != -1) continue;
                    return result;
                }
                catch (IOException e) {
                    LOGGER.error("FileChannel.read failed", (Throwable)e);
                }
            }
            this.reset();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public void commit(WriteOnlyGraph w, WriteTraits traits) throws ServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CASE]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Resource getType(Object value) {
        Class<?> clazz = value.getClass();
        Resource dataType = clazz == Float.class ? this.b.Float : (clazz == Double.class ? this.b.Double : (clazz == Integer.class ? this.b.Integer : (clazz == String.class ? this.b.String : (clazz == Boolean.class ? this.b.Boolean : (clazz == Byte.class ? this.b.Byte : (clazz == Long.class ? this.b.Long : (clazz == float[].class ? this.b.FloatArray : (clazz == double[].class ? this.b.DoubleArray : (clazz == int[].class ? this.b.IntegerArray : (clazz == String[].class ? this.b.StringArray : (clazz == boolean[].class ? this.b.BooleanArray : (clazz == byte[].class ? this.b.ByteArray : (clazz == long[].class ? this.b.LongArray : null)))))))))))));
        return dataType;
    }

    public long newCluster() {
        return -1 - ++this.writeState.clusterCount;
    }

    public long getDefaultCluster() {
        return this.writeState.defaultCluster;
    }

    public void setDefaultCluster(long cluster) {
        this.writeState.defaultCluster = cluster;
    }

    @Override
    public void syncRequest(final DelayedWrite request) throws DatabaseException {
        try {
            final DelayedWriteGraph dwg = new DelayedWriteGraph((ReadGraph)this);
            request.perform((WriteGraph)dwg);
            this.syncRequest((WriteOnly)new WriteOnlyRequest(){

                public void perform(WriteOnlyGraph graph) throws DatabaseException {
                    dwg.commit(graph, (WriteTraits)request);
                }
            });
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void syncRequest(WriteOnly request) throws DatabaseException {
        Resource defaultClusterSet = this.setClusterSet4NewResource(null);
        try {
            try {
                WriteSupport ws = (WriteSupport)this.session.getService(WriteSupport.class);
                ws.performWriteRequest((WriteGraph)this, request);
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        finally {
            this.setClusterSet4NewResource(defaultClusterSet);
        }
    }

    @Override
    public <T> T getService(Class<T> api) {
        if (ClusteringSupport.class == api) {
            final ClusteringSupport support = (ClusteringSupport)super.getService(api);
            return (T)new ClusteringSupport(){

                public int maximumClusterSize() {
                    return support.maximumClusterSize();
                }

                public Resource getResourceByIndexAndCluster(int resourceIndex, long clusterId) throws DatabaseException, ResourceNotFoundException {
                    return support.getResourceByIndexAndCluster(resourceIndex, clusterId);
                }

                public Resource getResourceByKey(int resourceKey) throws ResourceNotFoundException {
                    return support.getResourceByKey(resourceKey);
                }

                public int getNumberOfResources(long clusterId) throws DatabaseException {
                    return support.getNumberOfResources(clusterId);
                }

                public long getCluster(Resource r) {
                    return support.getCluster(r);
                }

                public long createCluster() {
                    return DelayedWriteGraph.this.newCluster();
                }

                public boolean isClusterSet(Resource r) throws DatabaseException {
                    return support.isClusterSet(r);
                }

                public Resource getClusterSetOfCluster(Resource r) throws DatabaseException {
                    return support.getClusterSetOfCluster(r);
                }

                public Resource getClusterSetOfCluster(long cluster) throws DatabaseException {
                    return support.getClusterSetOfCluster(cluster);
                }
            };
        }
        if (TransferableGraphSupport.class == api) {
            final TransferableGraphSupport parentSupport = (TransferableGraphSupport)this.session.getService(TransferableGraphSupport.class);
            return (T)new TransferableGraphSupport(){

                public void setValue(WriteOnlyGraph graph, Resource resource, VirtualGraph provider, byte[] raw) {
                    DelayedWriteGraph.this.writeByte(4);
                    DelayedWriteGraph.this.writeInt(DelayedWriteGraph.this.getId(resource));
                    DelayedWriteGraph.this.writeInt(raw.length);
                    DelayedWriteGraph.this.writeBytes(raw);
                    DelayedWriteGraph.this.writeInt(DelayedWriteGraph.this.getBindingId(PASSTHROUGH));
                }

                public void setValue(WriteOnlyGraph graph, Resource resource, VirtualGraph provider, ByteReader reader, int amount) throws DatabaseException {
                    DelayedWriteGraph.this.writeByte(4);
                    DelayedWriteGraph.this.writeInt(DelayedWriteGraph.this.getId(resource));
                    DelayedWriteGraph.this.writeInt(amount);
                    DelayedWriteGraph.this.writeBytes(reader.readBytes(null, amount));
                    DelayedWriteGraph.this.writeInt(DelayedWriteGraph.this.getBindingId(PASSTHROUGH));
                }

                public byte[] getValue(ReadGraph graph, Resource resource) throws DatabaseException {
                    return parentSupport.getValue(graph, resource);
                }

                public InputStream getValueStream(ReadGraph graph, Resource resource) {
                    return parentSupport.getValueStream(graph, resource);
                }
            };
        }
        return super.getService(api);
    }

    public <T> void addMetadata(Metadata data) throws ServiceException {
        MetadataUtils.addMetadata((Session)this.session, this.metadata, (Metadata)data);
    }

    public void addCommitAndContinue() {
        this.writeByte(7);
    }

    public <T extends Metadata> T getMetadata(Class<T> clazz) throws ServiceException {
        return (T)MetadataUtils.getMetadata((Session)this.session, this.metadata, clazz);
    }

    public TreeMap<String, byte[]> getMetadata() {
        return this.metadata;
    }

    @Override
    public <T> T syncRequest(WriteResult<T> request) throws DatabaseException {
        return (T)request.perform((WriteGraph)this);
    }

    public VirtualGraph getProvider() {
        return null;
    }

    public void clearUndoList(WriteTraits writeTraits) {
        WriteSupport ws = (WriteSupport)this.session.getService(WriteSupport.class);
        if (ws != null) {
            ws.clearUndoList(writeTraits);
        }
    }

    public void markUndoPoint() {
    }

    @Override
    public <T> T getPossibleRelatedValue(Resource subject, Resource relation, Binding binding) throws ManyObjectsForFunctionalRelationException, BindingException, ServiceException {
        if (!(subject instanceof InternalResource)) {
            return super.getPossibleRelatedValue(subject, relation, binding);
        }
        return null;
    }

    @Override
    public final Resource getPossibleObject(Resource subject, Resource relation) throws ManyObjectsForFunctionalRelationException, ServiceException {
        if (!(subject instanceof InternalResource)) {
            return super.getPossibleObject(subject, relation);
        }
        return null;
    }

    @Override
    public void close() {
        block26: {
            Object var2_4;
            block24: {
                if (this.writeState.out != null) {
                    try {
                        try {
                            Throwable throwable = null;
                            var2_4 = null;
                            try {
                                FileOutputStream out = this.writeState.out;
                                if (out != null) {
                                    ((OutputStream)out).close();
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to close delayed write graph temporary commit output stream", (Throwable)e);
                            this.writeState.out = null;
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        this.writeState.out = null;
                        throw throwable;
                    }
                    this.writeState.out = null;
                }
            }
            if (this.writeState.in != null) {
                try {
                    try {
                        Throwable e = null;
                        var2_4 = null;
                        try {
                            FileInputStream in = this.writeState.in;
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                        catch (Throwable throwable) {
                            if (e == null) {
                                e = throwable;
                            } else if (e != throwable) {
                                e.addSuppressed(throwable);
                            }
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to close delayed write graph temporary commit input stream", (Throwable)e);
                        this.writeState.in = null;
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    this.writeState.in = null;
                    throw throwable;
                }
                this.writeState.in = null;
            }
        }
        if (this.writeState.tempFile != null) {
            this.writeState.tempFile.delete();
            this.writeState.tempFile = null;
        }
    }

    private /* synthetic */ long lambda$0(long delayedId) {
        ResourceImpl real = (ResourceImpl)this.getResource((int)delayedId);
        long persistentId = this.processor.resourceSupport.getRandomAccessId(real.id);
        return persistentId;
    }

    private static class InternalResource
    implements Resource {
        int id;
        long clusterId = 0L;
        Resource resource = null;
        Resource clusterSet = null;

        public InternalResource(int id, long clusterId) {
            this.id = id;
            this.clusterId = clusterId;
        }

        public InternalResource(int id, Resource clusterSet) {
            this.id = id;
            this.clusterSet = clusterSet;
        }

        public long getResourceId() {
            return this.id;
        }

        public Resource get() {
            return this;
        }

        public boolean isPersistent() {
            return false;
        }

        public int compareTo(Resource o) {
            if (o instanceof InternalResource) {
                return Integer.compare(this.id, ((InternalResource)o).id);
            }
            return -1;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public int getThreadHash() {
            return this.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof InternalResource)) {
                return false;
            }
            InternalResource other = (InternalResource)obj;
            return this.id == other.id;
        }

        public boolean equalsResource(Resource other) {
            return this.equals(other);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[did=");
            sb.append(this.id);
            sb.append("]");
            return sb.toString();
        }
    }

    private static class State {
        public File tempFile;
        public FileOutputStream out;
        public FileInputStream in;
        public ArrayList<Resource> idToResource = new ArrayList();
        public TIntIntHashMap externalToId = new TIntIntHashMap(10, 0.5f, 0, -1);
        public ArrayList<Binding> idToBinding = new ArrayList();
        public TObjectIntHashMap<Binding> bindingToId = new TObjectIntHashMap(10, 0.5f, -1);
        public Set<Resource> clusterSets = new HashSet<Resource>();
        public Set<Resource> clusterSetsForExistingResources = new HashSet<Resource>();
        public int clusterCount = 0;
        public long defaultCluster;
        public Resource defaultClusterSet;
        public int statementCount = 0;
        public int valueCount = 0;
        public int fileCount = 0;

        private State() {
        }
    }
}

