/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.ByteFileReader;
import org.simantics.db.common.ByteFileWriter;
import org.simantics.db.common.StandardStatement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.support.VirtualGraphServerSupport;
import org.simantics.db.service.SerialisationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VirtualCluster {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualCluster.class);
    static final int[] EMPTY = new int[0];
    private final ArrayList<TIntArrayList> statements = new ArrayList();
    private final TIntHashSet lazy = new TIntHashSet();
    private final TIntObjectHashMap<byte[]> values = new TIntObjectHashMap();
    private final int clusterId;

    public VirtualCluster(int clusterId) {
        this.clusterId = clusterId;
    }

    public void dispose() {
        this.statements.clear();
        this.lazy.clear();
        this.values.clear();
    }

    public int clusterId() {
        return this.clusterId;
    }

    public void trim() {
    }

    private TIntArrayList getPredicateMap(int subject) {
        short rId = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(subject);
        if (rId >= this.statements.size()) {
            return null;
        }
        return this.statements.get(rId);
    }

    public boolean isPending(int subject) {
        return this.lazy.contains(subject);
    }

    boolean containsPredicate(TIntArrayList statements, int predicate) {
        int i = 0;
        while (i < statements.size()) {
            if (statements.getQuick(i) == predicate) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    int containsStatement(TIntArrayList statements, int predicate, int object) {
        int i = 0;
        while (i < statements.size()) {
            if (statements.getQuick(i) == predicate && statements.getQuick(i + 1) == object) {
                return i;
            }
            i += 2;
        }
        return -1;
    }

    public boolean isPending(int subject, int predicate) {
        if (!this.lazy.contains(subject)) {
            return false;
        }
        TIntArrayList predicateMap = this.getPredicateMap(subject);
        if (predicateMap == null) {
            return true;
        }
        return !this.containsPredicate(predicateMap, predicate);
    }

    public void resetLazy(int subject) {
        this.lazy.remove(subject);
        short ri = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(subject);
        this.statements.set(ri, new TIntArrayList());
    }

    public void setLazy(int subject) {
        this.lazy.add(subject);
    }

    public void finish(int subject) {
        this.lazy.remove(subject);
    }

    public void setValue(int subject, byte[] data, int length) {
        this.values.put(subject, (Object)Arrays.copyOf(data, length));
    }

    public void denyValue(int subject) {
        this.values.remove(subject);
    }

    public void addStatements(int subject, int[] data) {
        TIntArrayList result = this.getPredicateMap(subject);
        if (result == null) {
            result = new TIntArrayList();
            short rId = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(subject);
            this.statements.ensureCapacity(rId + 1);
            int i = this.statements.size();
            while (i < rId + 1) {
                this.statements.add(null);
                ++i;
            }
            this.statements.set(rId, result);
        }
        int i = 0;
        while (i < data.length) {
            int predicate = data[i];
            int object = data[i + 1];
            if (this.containsStatement(result, predicate, object) < 0) {
                result.add(predicate);
                result.add(object);
            }
            i += 2;
        }
    }

    public void claim(int subject, int predicate, int object) {
        TIntArrayList predicates = this.getPredicateMap(subject);
        if (predicates == null) {
            predicates = new TIntArrayList();
            short rId = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(subject);
            this.statements.ensureCapacity(rId + 1);
            int i = this.statements.size();
            while (i < rId + 1) {
                this.statements.add(null);
                ++i;
            }
            this.statements.set(rId, predicates);
        }
        if (this.containsStatement(predicates, predicate, object) < 0) {
            predicates.add(predicate);
            predicates.add(object);
        }
    }

    public void claimUnsafe(int subject, int predicate, int object) {
        TIntArrayList predicates = this.getPredicateMap(subject);
        if (predicates == null) {
            predicates = new TIntArrayList();
            short rId = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(subject);
            this.statements.ensureCapacity(rId + 1);
            int i = this.statements.size();
            while (i < rId + 1) {
                this.statements.add(null);
                ++i;
            }
            this.statements.set(rId, predicates);
        }
        predicates.add(predicate);
        predicates.add(object);
    }

    public void deny(int subject, int predicate, int object) {
        TIntArrayList predicates = this.getPredicateMap(subject);
        if (predicates == null) {
            return;
        }
        int index = this.containsStatement(predicates, predicate, object);
        if (index < 0) {
            return;
        }
        predicates.remove(index, 2);
    }

    int[] getObjects(int subject, int predicate) {
        TIntArrayList predicates = this.getPredicateMap(subject);
        if (predicates == null) {
            return EMPTY;
        }
        TIntArrayList result = new TIntArrayList();
        int i = 0;
        while (i < predicates.size()) {
            if (predicates.getQuick(i) == predicate) {
                result.add(predicates.getQuick(i + 1));
            }
            i += 2;
        }
        return result.toArray();
    }

    int[] getPredicates(int subject) {
        TIntArrayList predicates = this.getPredicateMap(subject);
        if (predicates == null) {
            return EMPTY;
        }
        TIntHashSet result = new TIntHashSet();
        int i = 0;
        while (i < predicates.size()) {
            result.add(predicates.getQuick(i));
            i += 2;
        }
        return result.toArray();
    }

    byte[] getValue(int subject) {
        return (byte[])this.values.get(subject);
    }

    public int getTransientClusterKey() {
        int clusterBits = ClusterTraitsBase.getClusterBits(this.clusterId >>> 1);
        if ((this.clusterId & 1) == 0) {
            return clusterBits | Integer.MIN_VALUE;
        }
        return clusterBits;
    }

    public int getTransientId(int subject) {
        if ((this.clusterId & 1) == 0) {
            return ClusterTraitsBase.createResourceKeyNoThrow(this.clusterId >> 1, subject) | Integer.MIN_VALUE;
        }
        return ClusterTraitsBase.createResourceKeyNoThrow(this.clusterId >> 1, subject);
    }

    public static long getClusterIdentifier(SerialisationSupport ss, int clusterKey) {
        if ((clusterKey & 1) == 0) {
            return clusterKey;
        }
        int rk = ClusterTraitsBase.createResourceKeyNoThrow(clusterKey >> 1, 1);
        try {
            return ss.getRandomAccessId(rk);
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not get cluster id for virtual cluster key=" + clusterKey, (Throwable)e);
            return -1L;
        }
    }

    public void saveImpl(File file, SerialisationSupport ss) throws IOException {
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            LOGGER.debug("DEBUG: Saving virtual cluster {} to {}", (Object)this.clusterId, (Object)file.getAbsolutePath());
        }
        final ByteFileWriter writer = new ByteFileWriter(file);
        try {
            int stms = 0;
            for (TIntArrayList list : this.statements) {
                if (list == null) continue;
                stms += list.size();
            }
            writer.write(3 * (stms >>= 1));
            int count = 0;
            int i = 0;
            while (i < this.statements.size()) {
                TIntArrayList list = this.statements.get(i);
                if (list != null) {
                    int j = 0;
                    while (j < list.size()) {
                        try {
                            writer.write((short)i);
                            int rk = list.getQuick(j);
                            long rid = ss.getRandomAccessId(rk);
                            writer.write(rid);
                            rk = list.getQuick(j + 1);
                            rid = ss.getRandomAccessId(rk);
                            writer.write(rid);
                            ++count;
                        }
                        catch (DatabaseException e) {
                            LOGGER.error("Failed to save statements of virtual cluster {} to {}", new Object[]{this.clusterId, file.getAbsolutePath(), e});
                        }
                        j += 2;
                    }
                }
                ++i;
            }
            writer.write(this.values.size());
            this.values.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<byte[]>(){

                public boolean execute(int a, byte[] b) {
                    writer.write(a);
                    writer.write(b.length);
                    writer.write(b);
                    return true;
                }
            });
            if (debug) {
                LOGGER.debug("TransientGraph[{}, {}] wrote {} statements and {} values to disk.", new Object[]{this.clusterId, file.getAbsolutePath(), count, this.values.size()});
            }
        }
        finally {
            writer.commit();
        }
    }

    public void load(File file, SerialisationSupport serialization, VirtualGraphServerSupport vgss, boolean unsafe) throws DatabaseException {
        boolean debug = LOGGER.isDebugEnabled();
        if (debug) {
            LOGGER.debug("DEBUG: Loading virtual cluster {} from {} (length {} bytes)", new Object[]{this.clusterId, file.getAbsolutePath(), file.length()});
        }
        try (ByteFileReader reader = null;){
            if (!file.exists()) {
                return;
            }
            try {
                reader = new ByteFileReader(file);
                int clusterInt = ClusterTraitsBase.getClusterBits(this.clusterId() >> 1);
                int stms = reader.readInt();
                if (!unsafe) {
                    i = 0;
                    while (i < stms) {
                        rId = reader.readShort();
                        sId = reader.readLong();
                        oId = reader.readLong();
                        if (sId != 0L && oId != 0L) {
                            sTransientId = serialization.getTransientId(sId);
                            oTransientId = serialization.getTransientId(oId);
                            if (vgss != null) {
                                vgss.addVirtual(clusterInt + rId);
                            }
                            this.claim(rId, sTransientId, oTransientId);
                        }
                        i += 3;
                    }
                } else {
                    i = 0;
                    while (i < stms) {
                        rId = reader.readShort();
                        sId = reader.readLong();
                        oId = reader.readLong();
                        if (sId != 0L && oId != 0L) {
                            sTransientId = serialization.getTransientId(sId);
                            oTransientId = serialization.getTransientId(oId);
                            if (vgss != null) {
                                vgss.addVirtual(clusterInt + rId);
                            }
                            this.claimUnsafe(rId, sTransientId, oTransientId);
                        }
                        i += 3;
                    }
                }
                int values = reader.readInt();
                int i = 0;
                while (i < values) {
                    int subject = reader.readInt();
                    int length = reader.readInt();
                    this.setValue(subject, reader.readBytes(length), length);
                    ++i;
                }
                if (debug) {
                    LOGGER.debug("DEBUG: TransientGraph[{}, {}] loaded {} statements and {} values from disk.", new Object[]{this.clusterId, file.getAbsolutePath(), stms / 3, values});
                }
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    void listStatements(SerialisationSupport ss, ArrayList<Statement> result) {
        int clusterKey = this.getTransientClusterKey();
        try {
            int i = 0;
            while (i < this.statements.size()) {
                TIntArrayList list = this.statements.get(i);
                if (list != null) {
                    Resource subject = ss.getResource(clusterKey | i);
                    int j = 0;
                    while (j < list.size()) {
                        Resource p = ss.getResource(list.getQuick(j));
                        Resource o = ss.getResource(list.getQuick(j + 1));
                        result.add((Statement)new StandardStatement(subject, p, o));
                        j += 2;
                    }
                }
                ++i;
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to list statements of virtual cluster {}", (Object)this.clusterId, (Object)e);
        }
    }

    void listValues(final SerialisationSupport ss, final ArrayList<Resource> result) {
        this.values.forEachKey(new TIntProcedure(){

            public boolean execute(int value) {
                try {
                    result.add(ss.getResource(VirtualCluster.this.getTransientId(value)));
                }
                catch (DatabaseException e) {
                    LOGGER.error("Failed to list values of virtual cluster {}", (Object)VirtualCluster.this.clusterId, (Object)e);
                }
                return true;
            }
        });
    }
}

