/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.AsyncReadEntry;
import org.simantics.db.impl.query.PendingTaskSupport;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;

public class BlockingAsyncProcedure<Result>
implements AsyncProcedure<Result>,
Runnable {
    private static final Object NO_RESULT = new Object();
    private final Object key;
    private final ReadGraphImpl queryGraph;
    private final ReadGraphImpl callerGraph;
    private final AsyncReadEntry<Result> entry;
    private final AsyncProcedure<Result> procedure;
    private PendingTaskSupport pendingTaskSupport;
    private final boolean needsToBlock;
    private Object result = NO_RESULT;
    private Throwable exception = null;

    public BlockingAsyncProcedure(ReadGraphImpl callerGraph, AsyncReadEntry<Result> entry, AsyncProcedure<Result> procedure, Object key, boolean needsToBlock) {
        this.queryGraph = callerGraph.withParent(entry, this, needsToBlock);
        callerGraph.asyncBarrier.inc();
        this.entry = entry;
        this.procedure = procedure;
        this.key = key;
        this.queryGraph.asyncBarrier.inc();
        this.callerGraph = callerGraph;
        this.needsToBlock = needsToBlock;
    }

    public void execute(AsyncReadGraph graph_, Result result) {
        this.result = result;
        this.queryGraph.asyncBarrier.dec();
    }

    public void exception(AsyncReadGraph graph_, Throwable t) {
        this.exception = t;
        this.queryGraph.asyncBarrier.dec();
    }

    public void waitBarrier() {
        this.queryGraph.asyncBarrier.waitBarrier(this.key, this.queryGraph);
    }

    public void dec() {
        this.queryGraph.asyncBarrier.dec();
    }

    public Result get() throws DatabaseException {
        if (this.needsToBlock) {
            this.queryGraph.asyncBarrier.waitBarrier(this.key, this.queryGraph);
        }
        if (this.exception != null) {
            if (this.exception instanceof DatabaseException) {
                throw (DatabaseException)this.exception;
            }
            throw new DatabaseException(this.exception);
        }
        return (Result)this.result;
    }

    public Result getResult() {
        return (Result)this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "." + String.valueOf(this.procedure);
    }

    @Override
    public void run() {
        AsyncReadEntry<Result> procedure__ = this.entry != null ? this.entry : this.procedure;
        ReadGraphImpl executeGraph = this.callerGraph.withParent(this.callerGraph.parent, null, this.needsToBlock);
        this.callerGraph.asyncBarrier.dec();
        try {
            try {
                if (procedure__ != null) {
                    procedure__.execute(executeGraph, this.get());
                }
            }
            catch (DatabaseException e) {
                if (procedure__ != null) {
                    procedure__.exception(executeGraph, e);
                }
                this.exception = e;
                if (this.entry != null) {
                    assert (this.entry.isReady());
                    this.entry.performFromCache(executeGraph, this.procedure);
                }
                executeGraph.asyncBarrier.dec();
                if (this.needsToBlock) {
                    executeGraph.asyncBarrier.waitBarrier(procedure__, executeGraph);
                }
            }
            catch (Throwable t) {
                block19: {
                    DatabaseException dbe = new DatabaseException(t);
                    if (procedure__ != null) {
                        procedure__.exception(executeGraph, dbe);
                    }
                    this.exception = dbe;
                    if (this.entry == null) break block19;
                    assert (this.entry.isReady());
                    this.entry.performFromCache(executeGraph, this.procedure);
                }
                executeGraph.asyncBarrier.dec();
                if (this.needsToBlock) {
                    executeGraph.asyncBarrier.waitBarrier(procedure__, executeGraph);
                }
            }
        }
        finally {
            if (this.entry != null) {
                assert (this.entry.isReady());
                this.entry.performFromCache(executeGraph, this.procedure);
            }
            executeGraph.asyncBarrier.dec();
            if (this.needsToBlock) {
                executeGraph.asyncBarrier.waitBarrier(procedure__, executeGraph);
            }
        }
    }

    public void print() {
        System.err.println("BlockingAsyncProcedure");
        System.err.println("-key: " + String.valueOf(this.key));
        System.err.println("-queryGraph: " + String.valueOf(this.queryGraph));
        System.err.println("-callerGraph: " + String.valueOf(this.callerGraph));
        System.err.println("-procedure: " + String.valueOf(this.procedure));
        System.err.println("-pendingTaskSupport: " + String.valueOf(this.pendingTaskSupport));
        System.err.println("-result: " + String.valueOf(this.result));
        System.err.println("-exception: " + String.valueOf(this.exception));
    }

    public Result performSync(AsyncRead<Result> request) throws DatabaseException {
        try {
            request.perform((AsyncReadGraph)this.queryGraph, (AsyncProcedure)this);
        }
        finally {
            this.dec();
        }
        return this.get();
    }

    public void performAsync(AsyncRead<Result> request) throws DatabaseException {
        try {
            request.perform((AsyncReadGraph)this.queryGraph, (AsyncProcedure)this);
        }
        finally {
            this.dec();
        }
    }
}

