/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.AsyncBarrierImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.AsyncMultiProcedure;

public class BlockingAsyncMultiProcedure<Result>
implements AsyncMultiProcedure<Result> {
    private static final Object NO_RESULT = new Object();
    private final Object key;
    private final AsyncBarrierImpl barrier;
    private final ReadGraphImpl procedureGraph;
    private final AsyncMultiProcedure<Result> procedure;
    private Object result = NO_RESULT;
    private Throwable exception = null;

    public BlockingAsyncMultiProcedure(AsyncBarrierImpl barrier, ReadGraphImpl procedureGraph, AsyncMultiProcedure<Result> procedure, Object key) {
        this.procedure = procedure;
        this.key = key;
        this.barrier = barrier;
        this.barrier.inc();
        this.procedureGraph = procedureGraph;
    }

    public void execute(AsyncReadGraph graph, Result result) {
        this.result = result;
        try {
            if (this.procedure != null) {
                this.procedure.execute((AsyncReadGraph)this.procedureGraph, result);
            }
        }
        catch (Throwable throwable) {
            Logger.defaultLogError((String)("AsyncProcedure.execute threw for " + String.valueOf(this.procedure)), (Throwable)throwable);
        }
    }

    public void finished(AsyncReadGraph graph) {
        try {
            try {
                if (this.procedure != null) {
                    this.procedure.finished((AsyncReadGraph)this.procedureGraph);
                }
            }
            catch (Throwable throwable) {
                Logger.defaultLogError((String)("AsyncProcedure.finish threw for " + String.valueOf(this.procedure)), (Throwable)throwable);
                this.barrier.dec();
            }
        }
        finally {
            this.barrier.dec();
        }
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        this.exception = t;
        try {
            try {
                if (this.procedure != null) {
                    this.procedure.exception((AsyncReadGraph)this.procedureGraph, t);
                }
            }
            catch (Throwable throwable) {
                Logger.defaultLogError((String)("AsyncProcedure.exception threw for " + String.valueOf(this.procedure)), (Throwable)throwable);
                this.barrier.dec();
            }
        }
        finally {
            this.barrier.dec();
        }
    }

    public Result get() throws DatabaseException {
        this.barrier.waitBarrier(this.key, this.procedureGraph);
        if (this.exception != null) {
            if (this.exception instanceof DatabaseException) {
                throw (DatabaseException)this.exception;
            }
            throw new DatabaseException(this.exception);
        }
        return (Result)this.result;
    }

    public Result getResult() {
        return (Result)this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        return "." + String.valueOf(this.procedure);
    }
}

