/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.QueryDeserializer;

abstract public class QueryFactoryBase implements QueryFactoryImpl {

    abstract protected CacheEntryBase readKeyAndValue(QueryDeserializerImpl deserializer) throws DatabaseException;
    
    @Override
    final public void read(QueryDeserializer deserializer) throws DatabaseException {
    	QueryDeserializerImpl impl = (QueryDeserializerImpl)deserializer;
        CacheEntryBase entry = readKeyAndValue(impl);
        impl.setEntry(entry);
        readParents(impl);
    }

    final public void parent(QueryDeserializer deserializer) throws DatabaseException {
    	QueryDeserializerImpl impl = (QueryDeserializerImpl)deserializer;
        CacheEntryBase ceb = reference(impl);
        impl.listening.addParent(impl.getEntry(), ceb);
    }
 
    @Override
    public void readEntry(QueryDeserializer deserializer) throws DatabaseException {
    	throw new IllegalStateException();
    }
    
}
