/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - improvements
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.request.RequestFlags;

import gnu.trove.ext.DualIdContainer;

public abstract class BinaryQuery<Procedure> extends CacheEntryBase<Procedure> implements Query, DualIdContainer {

	final public long id;

	public BinaryQuery(final long r1, final long r2) {
        assert(r1 != 0);
        assert(r2 != 0);
        id = id(r1,r2);
        assert(id != 0);
    }
	
	@Override
	int makeHash() {
		return r1() ^ r2();
	}
	
    final public int r1() {
        return (int)(id>>>32);
    }
    
    @Override
    final public int primaryId() {
        return (int)(id>>>32);
    }

    final public int r2() {
        return (int)id;
    }
    
    final public long longId() {
        return id;
    }

    final protected static long id(long r1, long r2) {
        long result = (r1<<32) | (r2 & 0xffffffffL); 
        return result;
    }
    
    @Override
    public int type() {
        return RequestFlags.INVALIDATE;
    }
    
	@Override
    final public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        BinaryQuery<?> other = (BinaryQuery<?>)object;
        return id == other.id;
    }
	
    @Override
    final public Query getQuery() {
        return this;
    }

    abstract public void removeEntry(QueryProcessor provider);

    @Override
    public long cluster(QuerySerializerImpl serializer) {
        return serializer.processor.cluster(r1());
    }

    @Override
    public void serializeKey(QuerySerializerImpl serializer) {
        serializer.addResource(r1());
        serializer.addResource(r2());
    }

}
