/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.procedure;

import java.util.concurrent.atomic.AtomicBoolean;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procedure.AsyncProcedure;

public class CallWrappedSingleQueryProcedure4<Result> implements AsyncProcedure<Result> {

	final private Object key;
    final private AsyncProcedure<Result> procedure;
    final private AtomicBoolean latch = new AtomicBoolean(false);
    
    public CallWrappedSingleQueryProcedure4(AsyncProcedure<Result> procedure, Object key) {
        this.procedure = procedure;
        this.key = key;
    }
    
    @Override
    public void execute(AsyncReadGraph graph, Result result) {
    	if(latch.compareAndSet(false, true)) {
        	try {
        		procedure.execute(graph, result);
        	} catch (Throwable t) {
        		Logger.defaultLogError("AsyncProcedure.exception failed for " + procedure, t);
        	} finally {
        	}
    	} else {
    		Logger.defaultLogError("Execute or exception was called many times (this time is execute)");
    	}
    }

    @Override
    public void exception(AsyncReadGraph graph, Throwable t) {
    	if(latch.compareAndSet(false, true)) {
        	try {
        		procedure.exception(graph, t);
        	} catch (Throwable throwable) {
        		Logger.defaultLogError("AsyncProcedure.exception failed for " + procedure, throwable);
        	} finally {
        	}
    	} else {
    		Logger.defaultLogError("Execute or exception was called many times (this time is exception)");
    	}
    }
	
}
