/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl;

import java.util.function.Consumer;

import org.simantics.db.VirtualGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;

public interface VirtualGraphImpl extends VirtualGraph {

    public int newResource(boolean lazy);

	public void claim(int subject, int predicate, int object);
    public int[] getObjects(int subject, int predicate);
    public int[] getPredicates(int subject);
    public byte[] getValue(int resource);
    public void deny(int subject, int predicate, int object);
    public void claimValue(int resource, byte[] object, int length);
    public void denyValue(int resource);
    
    public boolean isPending(int resource);
    public boolean isPending(int resource, int predicate);
    
    public void load(ReadGraphImpl graph, int resource, int predicate, Consumer<ReadGraphImpl> callback) throws DatabaseException;
    public void load(ReadGraphImpl graph, int resource, Consumer<ReadGraphImpl> callback) throws DatabaseException;

}

