/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils.traverser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.traverser.TraverseResult;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;

public class TraverseQuery
implements Read<TraverseResult>,
ReadInterface<TraverseResult> {
    public final Resource[] startResources;
    public final Resource[] instancesOfTypesToFollowTo;
    public final Resource[] inheritedFromTypesToFollowTo;
    public final Resource[] relations;
    public final Resource[] instancesOfTypesToAddToResult;
    public final Resource[] inheritedFromTypesToAddToResult;
    private int hash;

    public TraverseQuery(Resource[] startResources, Resource[] instancesOfTypesToFollowTo, Resource[] relations, Resource[] instancesOfTypesToAddToResult, Resource[] inheritedFromTypesToFollowTo, Resource[] inheritedFromTypesToAddToResult) {
        Resource r;
        this.startResources = startResources;
        this.relations = relations;
        this.instancesOfTypesToFollowTo = instancesOfTypesToFollowTo;
        this.instancesOfTypesToAddToResult = instancesOfTypesToAddToResult;
        this.inheritedFromTypesToFollowTo = inheritedFromTypesToFollowTo;
        this.inheritedFromTypesToAddToResult = inheritedFromTypesToAddToResult;
        int hash = 345436534;
        Resource[] resourceArray = startResources;
        int n = startResources.length;
        int n2 = 0;
        while (n2 < n) {
            r = resourceArray[n2];
            hash = 13 * hash + r.hashCode();
            ++n2;
        }
        resourceArray = relations;
        n = relations.length;
        n2 = 0;
        while (n2 < n) {
            r = resourceArray[n2];
            hash = 7 * hash + r.hashCode();
            ++n2;
        }
        resourceArray = instancesOfTypesToFollowTo;
        n = instancesOfTypesToFollowTo.length;
        n2 = 0;
        while (n2 < n) {
            r = resourceArray[n2];
            hash = 3 * hash + r.hashCode();
            ++n2;
        }
        resourceArray = instancesOfTypesToAddToResult;
        n = instancesOfTypesToAddToResult.length;
        n2 = 0;
        while (n2 < n) {
            r = resourceArray[n2];
            hash = 11 * hash + r.hashCode();
            ++n2;
        }
        resourceArray = inheritedFromTypesToFollowTo;
        n = inheritedFromTypesToFollowTo.length;
        n2 = 0;
        while (n2 < n) {
            r = resourceArray[n2];
            hash = 3 * hash + r.hashCode();
            ++n2;
        }
        resourceArray = inheritedFromTypesToAddToResult;
        n = inheritedFromTypesToAddToResult.length;
        n2 = 0;
        while (n2 < n) {
            r = resourceArray[n2];
            hash = 11 * hash + r.hashCode();
            ++n2;
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TraverseQuery)) {
            return false;
        }
        TraverseQuery other = this;
        if (this.hash != other.hash) {
            return false;
        }
        if (!Arrays.deepEquals(this.startResources, other.startResources)) {
            return false;
        }
        if (!Arrays.deepEquals(this.relations, other.relations)) {
            return false;
        }
        if (!Arrays.deepEquals(this.instancesOfTypesToFollowTo, other.instancesOfTypesToFollowTo)) {
            return false;
        }
        if (!Arrays.deepEquals(this.instancesOfTypesToAddToResult, other.instancesOfTypesToAddToResult)) {
            return false;
        }
        if (!Arrays.deepEquals(this.inheritedFromTypesToFollowTo, other.inheritedFromTypesToFollowTo)) {
            return false;
        }
        return Arrays.deepEquals(this.inheritedFromTypesToAddToResult, other.inheritedFromTypesToAddToResult);
    }

    public void request(AsyncRequestProcessor processor, AsyncProcedure<TraverseResult> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, Procedure<TraverseResult> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, SyncProcedure<TraverseResult> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, AsyncListener<TraverseResult> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, Listener<TraverseResult> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, SyncListener<TraverseResult> procedure) {
        processor.asyncRequest((Read)this, procedure);
    }

    public TraverseResult request(RequestProcessor processor) throws DatabaseException {
        return (TraverseResult)processor.syncRequest((Read)this);
    }

    public TraverseResult perform(ReadGraph graph) throws DatabaseException {
        Traverser traverser = new Traverser();
        Resource[] resourceArray = this.startResources;
        int n = this.startResources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            traverser.toBeVisited.add(r);
            ++n2;
        }
        while (!traverser.toBeVisited.isEmpty()) {
            this._doTraverse(graph, traverser);
        }
        return traverser.result;
    }

    void _doTraverse(ReadGraph graph, Traverser traverser) throws ServiceException {
        while (!traverser.toBeVisited.isEmpty()) {
            Resource r = traverser.toBeVisited.removeFirst();
            if (traverser.visited.contains(r)) continue;
            Resource[] resourceArray = this.relations;
            int n = this.relations.length;
            int n2 = 0;
            while (n2 < n) {
                Resource relation = resourceArray[n2];
                for (Resource obj : graph.getObjects(r, relation)) {
                    Resource acceptedType;
                    if (traverser.visited.contains(obj)) continue;
                    boolean isAcceptedObject = false;
                    Resource[] resourceArray2 = this.instancesOfTypesToFollowTo;
                    int n3 = this.instancesOfTypesToFollowTo.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        acceptedType = resourceArray2[n4];
                        if (isAcceptedObject |= graph.isInstanceOf(obj, acceptedType)) break;
                        ++n4;
                    }
                    if (!isAcceptedObject) {
                        resourceArray2 = this.inheritedFromTypesToFollowTo;
                        n3 = this.inheritedFromTypesToFollowTo.length;
                        n4 = 0;
                        while (n4 < n3) {
                            acceptedType = resourceArray2[n4];
                            if (isAcceptedObject |= graph.isInheritedFrom(obj, acceptedType)) break;
                            ++n4;
                        }
                    }
                    if (!isAcceptedObject) continue;
                    traverser.toBeVisited.add(obj);
                }
                ++n2;
            }
            boolean addToResult = false;
            Resource[] resourceArray3 = this.instancesOfTypesToAddToResult;
            int n5 = this.instancesOfTypesToAddToResult.length;
            n = 0;
            while (n < n5) {
                Resource typeToAddToResult = resourceArray3[n];
                if (addToResult |= graph.isInstanceOf(r, typeToAddToResult)) break;
                ++n;
            }
            if (!addToResult) {
                resourceArray3 = this.inheritedFromTypesToAddToResult;
                n5 = this.inheritedFromTypesToAddToResult.length;
                n = 0;
                while (n < n5) {
                    Resource typeToAddToResult = resourceArray3[n];
                    if (addToResult |= graph.isInheritedFrom(r, typeToAddToResult)) break;
                    ++n;
                }
            }
            if (addToResult) {
                traverser.result.result.add(r);
            }
            traverser.visited.add(r);
        }
    }

    class Traverser {
        TraverseResult result = new TraverseResult();
        public Set<Resource> visited = new HashSet<Resource>();
        public LinkedList<Resource> toBeVisited = new LinkedList();

        Traverser() {
        }
    }
}

