/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class NearestOwnerFinder {
    private static final int FIRST_DISTANCE = 1;
    private static final int UNVISITED = 0;
    private static final int NOT_INTERESTING_ANYMORE = -1;
    private final ReadGraph graph;
    private final Layer0 L0;
    private final TObjectIntHashMap<Resource> resourceStatus = new TObjectIntHashMap();
    private int nearestOwnerDistance;
    private Resource nearestOwner;

    private NearestOwnerFinder(ReadGraph graph, Layer0 L0) {
        this.graph = graph;
        this.L0 = L0;
    }

    private void browseOwnersOfInput(Collection<Resource> owners) throws DatabaseException {
        Iterator<Resource> it = owners.iterator();
        while (it.hasNext()) {
            Resource owner = it.next();
            if (!this.browsePilot(owner, 1)) continue;
            this.nearestOwner = owner;
            this.nearestOwnerDistance = 1;
            while (it.hasNext()) {
                this.browseNonpilot(it.next());
            }
            return;
        }
    }

    private boolean browsePilot(Resource resource, int distance) throws DatabaseException {
        if (this.resourceStatus.putIfAbsent((Object)resource, distance) != 0) {
            return false;
        }
        Collection<Resource> owners = NearestOwnerFinder.getDirectOwners(this.graph, this.L0, resource);
        if (owners.isEmpty()) {
            return true;
        }
        for (Resource owner : owners) {
            if (!this.browsePilot(owner, distance + 1)) continue;
            return true;
        }
        this.resourceStatus.put((Object)resource, -1);
        return false;
    }

    private void browseNonpilot(Resource resource) throws DatabaseException {
        int status = this.resourceStatus.put((Object)resource, -1);
        if (status == 0) {
            Collection<Resource> owners = NearestOwnerFinder.getDirectOwners(this.graph, this.L0, resource);
            if (owners.isEmpty()) {
                this.nearestOwnerDistance = Integer.MAX_VALUE;
                this.nearestOwner = null;
                return;
            }
            for (Resource owner : owners) {
                this.browseNonpilot(owner);
            }
        } else if (status > this.nearestOwnerDistance) {
            this.nearestOwnerDistance = status;
            this.nearestOwner = resource;
        }
    }

    private static Collection<Resource> getDirectOwners(ReadGraph graph, Layer0 L0, Resource resource) throws DatabaseException {
        HashSet<Resource> owners = graph.getObjects(resource, L0.IsOwnedBy);
        if (owners.isEmpty()) {
            if (resource.equals(graph.getRootLibrary())) {
                return Collections.emptyList();
            }
            owners = new THashSet();
            for (Statement statement : graph.getStatements(resource, L0.IsWeaklyRelatedTo)) {
                Resource inverse = graph.getPossibleInverse(statement.getPredicate());
                if (inverse == null || !graph.isSubrelationOf(inverse, L0.IsRelatedTo) || resource.equals(statement.getObject())) continue;
                owners.add(statement.getObject());
            }
        } else if (owners.size() > 1) {
            owners = new HashSet<Resource>(owners);
        }
        return owners;
    }

    public static Resource getNearestOwner(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection<Resource> owners = NearestOwnerFinder.getDirectOwners(graph, L0, resource);
        if (owners.size() == 1) {
            return owners.iterator().next();
        }
        if (owners.isEmpty()) {
            return null;
        }
        NearestOwnerFinder finder = new NearestOwnerFinder(graph, L0);
        finder.resourceStatus.put((Object)resource, -1);
        finder.browseOwnersOfInput(owners);
        return finder.nearestOwner;
    }

    public static Resource getNearestOwnerFromDirectOwners(ReadGraph graph, Collection<Resource> owners) throws DatabaseException {
        if (owners.size() == 1) {
            return owners.iterator().next();
        }
        if (owners.isEmpty()) {
            return null;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        NearestOwnerFinder finder = new NearestOwnerFinder(graph, L0);
        finder.browseOwnersOfInput(owners);
        return finder.nearestOwner;
    }
}

