/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.uri;

import java.util.Arrays;
import java.util.Map;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.EscapedChildMapOfResource;
import org.simantics.db.common.uri.URIEscape;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;

public class URIToResource
implements AsyncRead<Resource> {
    String[] nameSequence;

    public URIToResource(String[] nameSequence) {
        this.nameSequence = nameSequence;
    }

    public URIToResource(String uri) {
        this.nameSequence = URIEscape.splitURI(uri);
    }

    public void perform(AsyncReadGraph g, final AsyncProcedure<Resource> procedure) {
        if (this.nameSequence.length == 0) {
            procedure.execute(g, (Object)g.getRootLibrary());
        } else {
            g.asyncRequest((AsyncRead)new URIToResource(Arrays.copyOf(this.nameSequence, this.nameSequence.length - 1)), (AsyncProcedure)new AsyncProcedure<Resource>(){

                public void execute(AsyncReadGraph g, Resource result) {
                    g.asyncRequest((AsyncRead)new EscapedChildMapOfResource(result), (AsyncProcedure)new AsyncProcedure<Map<String, Resource>>(){

                        public void execute(AsyncReadGraph g, Map<String, Resource> map) {
                            Resource r = map.get((this).URIToResource.this.nameSequence[(this).URIToResource.this.nameSequence.length - 1]);
                            if (r != null) {
                                procedure.execute(g, (Object)r);
                            } else {
                                procedure.exception(g, (Throwable)new ResourceNotFoundException(URIEscape.joinURI((this).URIToResource.this.nameSequence)));
                            }
                        }

                        public void exception(AsyncReadGraph g, Throwable t) {
                            procedure.exception(g, t);
                        }
                    });
                }

                public void exception(AsyncReadGraph g, Throwable t) {
                    procedure.exception(g, t);
                }
            });
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.nameSequence);
    }

    public int threadHash() {
        return this.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof URIToResource)) {
            return false;
        }
        return Arrays.equals(this.nameSequence, ((URIToResource)obj).nameSequence);
    }

    public int getFlags() {
        return 0;
    }
}

