/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceReadBase;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.QuerySerializer;

public abstract class ResourceRead<T>
extends ResourceReadBase<T> {
    protected final Resource resource;

    public int hashCode() {
        return this.resource.hashCode() + this.classHash();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResourceRead r = (ResourceRead)object;
        return this.resource.equals(r.resource);
    }

    protected ResourceRead(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource.");
        }
        this.resource = resource;
    }

    public final boolean isImmutable(ReadGraph graph) throws DatabaseException {
        return graph.isImmutable(this.resource);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "|" + String.valueOf(this.resource);
    }

    public long cluster(QuerySerializer serializer) {
        return serializer.cluster(this.resource);
    }

    public void serializeKey(QuerySerializer serializer) {
        serializer.addResource(this.resource);
    }
}

