/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.ReadInterface;

public abstract class ResourceAsyncRead<T>
implements AsyncRead<T>,
ReadInterface<T> {
    protected final Resource resource;

    public final int hashCode() {
        return this.resource.hashCode();
    }

    public int threadHash() {
        return this.resource.getThreadHash();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ResourceAsyncRead r = (ResourceAsyncRead)object;
        return this.resource.equals(r.resource);
    }

    public int getFlags() {
        return 0;
    }

    public ResourceAsyncRead(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource.");
        }
        this.resource = resource;
    }

    public void request(AsyncRequestProcessor processor, AsyncProcedure<T> procedure) {
        processor.asyncRequest((AsyncRead)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, Procedure<T> procedure) {
        processor.asyncRequest((AsyncRead)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, SyncProcedure<T> procedure) {
        processor.asyncRequest((AsyncRead)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, AsyncListener<T> procedure) {
        processor.asyncRequest((AsyncRead)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, Listener<T> procedure) {
        processor.asyncRequest((AsyncRead)this, procedure);
    }

    public void request(AsyncRequestProcessor processor, SyncListener<T> procedure) {
        processor.asyncRequest((AsyncRead)this, procedure);
    }

    public T request(RequestProcessor processor) throws DatabaseException {
        return (T)processor.syncRequest((AsyncRead)this);
    }
}

