/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class IsEnumeratedValue
extends ResourceRead<Boolean> {
    public IsEnumeratedValue(Resource resource) {
        super(resource);
    }

    public Boolean perform(ReadGraph graph) throws DatabaseException {
        return IsEnumeratedValue.isEnumeratedValue(graph, this.resource);
    }

    public static boolean isEnumeratedValue(ReadGraph graph, Resource resource) throws DatabaseException {
        Set types = graph.getTypes(resource);
        for (Resource type : types) {
            if (!IsEnumeratedValue.isEnumeration(graph, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnumeration(ReadGraph graph, Resource type) throws DatabaseException {
        return graph.hasStatement(type, Layer0.getInstance((ReadGraph)graph).Enumeration, type);
    }
}

