/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.processor;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.processor.ProcessorBase;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.WriteOnly;

public final class MergingWriteOnlyProcessor
extends ProcessorBase {
    final long transactionKeepalivePeriod;
    final ConcurrentLinkedQueue<WriteOnly> queue = new ConcurrentLinkedQueue();
    private final AsyncRequestProcessor processor;
    private final VirtualGraph vg;
    boolean hasAlreadyRequest = false;

    public MergingWriteOnlyProcessor(AsyncRequestProcessor processor, VirtualGraph vg, long transactionKeepalivePeriod) {
        this.processor = processor;
        this.vg = vg;
        this.transactionKeepalivePeriod = transactionKeepalivePeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncRequest(WriteOnly request) {
        this.queue.add(request);
        MergingWriteOnlyProcessor mergingWriteOnlyProcessor = this;
        synchronized (mergingWriteOnlyProcessor) {
            if (!this.hasAlreadyRequest) {
                this.processor.asyncRequest((WriteOnly)new MergedWrite(this.vg));
                this.hasAlreadyRequest = true;
            } else {
                this.notify();
            }
        }
    }

    public String toString() {
        return "MergingWriteOnlyProcessor@" + System.identityHashCode(this) + " (based on " + String.valueOf(this.processor) + ")";
    }

    class MergedWrite
    extends WriteOnlyRequest {
        public MergedWrite(VirtualGraph vg) {
            super(vg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(WriteOnlyGraph graph) throws DatabaseException {
            while (true) {
                WriteOnly next;
                if ((next = MergingWriteOnlyProcessor.this.queue.poll()) == null) {
                    MergingWriteOnlyProcessor mergingWriteOnlyProcessor = MergingWriteOnlyProcessor.this;
                    synchronized (mergingWriteOnlyProcessor) {
                        if (MergingWriteOnlyProcessor.this.transactionKeepalivePeriod > 0L) {
                            try {
                                MergingWriteOnlyProcessor.this.wait(MergingWriteOnlyProcessor.this.transactionKeepalivePeriod);
                            }
                            catch (InterruptedException e) {
                                Logger.defaultLogError(e);
                            }
                            next = MergingWriteOnlyProcessor.this.queue.poll();
                        }
                        if (next == null) {
                            MergingWriteOnlyProcessor.this.hasAlreadyRequest = false;
                            return;
                        }
                    }
                }
                try {
                    next.perform(graph);
                    continue;
                }
                catch (Throwable t) {
                    Logger.defaultLogError(t);
                    continue;
                }
                break;
            }
        }
    }
}

