/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.procedure.single.wrapper;

import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.procedure.AsyncProcedure;

public final class SingleOrNullProcedure<Result>
extends AsyncMultiProcedureAdapter<Result> {
    private Result result = null;
    final AsyncProcedure<Result> procedure;
    final AtomicBoolean found = new AtomicBoolean(false);
    final AtomicBoolean done = new AtomicBoolean(false);

    public SingleOrNullProcedure(AsyncProcedure<Result> procedure) {
        this.procedure = procedure;
    }

    @Override
    public void finished(AsyncReadGraph graph) {
        if (this.done.compareAndSet(false, true)) {
            try {
                this.procedure.execute(graph, this.result);
            }
            catch (Throwable t) {
                Logger.defaultLogError(t);
            }
        }
    }

    @Override
    public void execute(AsyncReadGraph graph, Result result) {
        if (this.found.compareAndSet(false, true)) {
            this.result = result;
        } else if (this.done.compareAndSet(false, true)) {
            try {
                this.procedure.execute(graph, null);
            }
            catch (Throwable t) {
                Logger.defaultLogError(t);
            }
        }
    }

    @Override
    public void exception(AsyncReadGraph graph, Throwable t) {
        if (this.done.compareAndSet(false, true)) {
            try {
                this.procedure.exception(graph, t);
            }
            catch (Throwable t2) {
                Logger.defaultLogError(t2);
            }
        }
    }

    public String toString() {
        return "SingleOrNullProcedure -> " + String.valueOf(this.procedure);
    }
}

