/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.procedure.single;

import java.util.Collection;
import java.util.HashSet;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;

public abstract class SingleSetSyncListener<T>
implements AsyncListener<Collection<T>> {
    private Collection<T> previous = null;

    public boolean start(ReadGraph graph) throws DatabaseException {
        return true;
    }

    public void add(ReadGraph graph, T item) throws DatabaseException {
    }

    public void remove(ReadGraph graph, T item) throws DatabaseException {
    }

    public void finished(ReadGraph graph) throws DatabaseException {
    }

    public void exception(ReadGraph graph, Throwable t) throws DatabaseException {
        Logger.defaultLogError(t);
    }

    public final void execute(AsyncReadGraph graph, final Collection<T> result) {
        if (result == null) {
            Logger.defaultLogError("SingleSetSyncListener does not accept null result.");
            return;
        }
        graph.asyncRequest((Read)new ReadRequest(){

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                if (!SingleSetSyncListener.this.start(graph)) {
                    return;
                }
                if (SingleSetSyncListener.this.previous == null) {
                    for (Object t : result) {
                        SingleSetSyncListener.this.add(graph, t);
                    }
                } else {
                    HashSet added = new HashSet(result);
                    added.removeAll(SingleSetSyncListener.this.previous);
                    HashSet removed = new HashSet(SingleSetSyncListener.this.previous);
                    removed.removeAll(result);
                    for (Object t : added) {
                        SingleSetSyncListener.this.add(graph, t);
                    }
                    for (Object t : removed) {
                        SingleSetSyncListener.this.remove(graph, t);
                    }
                }
                SingleSetSyncListener.this.finished(graph);
                SingleSetSyncListener.this.previous = result;
            }
        }, (AsyncProcedure)new AsyncProcedure<Object>(){

            public void exception(AsyncReadGraph graph, Throwable t) {
                Logger.defaultLogError(t);
            }

            public void execute(AsyncReadGraph graph, Object result) {
            }
        });
    }

    public final void exception(AsyncReadGraph graph, final Throwable throwable) {
        graph.asyncRequest((Read)new ReadRequest(){

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                SingleSetSyncListener.this.exception(graph, throwable);
            }
        });
    }
}

