/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.procedure.guarded;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.procedure.adapter.AsyncProcedureAdapter;
import org.simantics.db.procedure.AsyncProcedure;

public class GuardedAsyncProcedureWrapper<T>
extends AsyncProcedureAdapter<T> {
    private final AsyncProcedure<T> procedure;
    private final AtomicBoolean onceGuard = new AtomicBoolean(false);
    private final AtomicInteger resultCounter;

    public GuardedAsyncProcedureWrapper(AsyncProcedure<T> procedure, int expectedResults) {
        this.procedure = procedure;
        this.resultCounter = new AtomicInteger(expectedResults);
    }

    @Override
    public void exception(AsyncReadGraph graph, Throwable t) {
        if (this.onceGuard.compareAndSet(false, true)) {
            this.procedure.exception(graph, t);
        }
    }

    @Override
    public void execute(AsyncReadGraph graph, T result) {
        int count = this.resultCounter.decrementAndGet();
        if (count == 0) {
            if (this.onceGuard.compareAndSet(false, true)) {
                this.procedure.execute(graph, result);
            }
        } else if (count < 0) {
            System.out.println(String.valueOf(this) + ": execute invoked more than expected (count=" + count + ", procedure=" + String.valueOf(this.procedure) + ")");
        }
    }
}

