/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.scl.compiler.elaboration.java.ExternalConstantException;
import org.simantics.scl.compiler.elaboration.java.JavaExternalConstantReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardExternalConstantReader
extends JavaExternalConstantReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardExternalConstantReader.class);
    private static final String RESOURCE = "resource";
    private final SerialisationSupport ss;

    StandardExternalConstantReader(SerialisationSupport ss) {
        this.ss = ss;
    }

    public void writeExternal(ObjectOutput out, Object value) throws IOException {
        if (value instanceof Resource) {
            out.writeUTF(RESOURCE);
            try {
                out.writeLong(this.ss.getRandomAccessId((Resource)value));
                return;
            }
            catch (DatabaseException e) {
                LOGGER.error("Error while storing a resource reference", (Throwable)e);
                throw new IOException(e);
            }
        }
        super.writeExternal(out, value);
    }

    public Object readExternal(ObjectInput in, String key) throws IOException, ClassNotFoundException {
        if ("extern".equals(key)) {
            try {
                return in.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new ExternalConstantException("Failed to load class " + e.getMessage());
            }
        }
        if (RESOURCE.equals(key)) {
            try {
                return this.ss.getResource(in.readLong());
            }
            catch (DatabaseException e) {
                LOGGER.error("Error while reading a resource reference", (Throwable)e);
                throw new IOException(e);
            }
        }
        return super.readExternal(in, key);
    }
}

