/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import org.simantics.db.ReadGraph;
import org.simantics.db.service.QueryControl;

public class QueryMemoryWatcher {
    final ReadGraph graph;
    final QueryControl support;
    final int stopTime;
    final long baseline;
    final long highLimit;
    final long lowLimit;
    boolean collecting = false;

    public QueryMemoryWatcher(ReadGraph graph, int allowedQueries) {
        this(graph, allowedQueries, 0.5, 10);
    }

    public QueryMemoryWatcher(ReadGraph graph, int allowedQueries, double ratio, int stopTime) {
        this.support = (QueryControl)graph.getService(QueryControl.class);
        this.baseline = this.support.count();
        this.highLimit = this.baseline + (long)allowedQueries;
        this.lowLimit = this.baseline + (long)((int)((double)allowedQueries * ratio));
        this.graph = graph;
        this.stopTime = 10;
    }

    public void maintain() {
        long current = this.support.count();
        if (this.collecting) {
            if (current > this.lowLimit) {
                this.support.gc(this.graph, this.stopTime);
            } else {
                this.collecting = false;
            }
        } else if (current > this.highLimit) {
            this.collecting = true;
        }
    }
}

