/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.db.common.utils.Logger;

public class CommitMetadata
implements Metadata {
    final boolean DEBUG = true;
    public final long opid;
    public final Date date;

    public CommitMetadata(long opid) {
        this.opid = opid;
        this.date = new Date();
    }

    public CommitMetadata(long opid, Date date) {
        this.opid = opid;
        this.date = date;
    }

    public byte[] serialise(Session session) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeLong(this.opid);
            oos.writeObject(this.date);
            oos.close();
            return os.toByteArray();
        }
        catch (Exception e) {
            Logger.defaultLogError(e.toString());
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static CommitMetadata deserialise(Session session, byte[] input) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(input);
            ObjectInputStream ois = new ObjectInputStream(is);
            long opid = ois.readLong();
            Object date = ois.readObject();
            ois.close();
            if (date instanceof Date) {
                return new CommitMetadata(opid, (Date)date);
            }
        }
        catch (Throwable e) {
            Logger.defaultLogError(e);
        }
        return null;
    }
}

