/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.service.Bytes;

public final class ByteFileReader {
    public static int BUFFER = 65536;
    private final FileInputStream fs;
    private final ReadableByteChannel channel;
    private final ByteBuffer byteBuffer;
    private final byte[] bytes = new byte[BUFFER];
    private int size;
    protected int byteIndex = 0;

    protected final ReadableByteChannel getChannel() {
        return this.channel;
    }

    protected final ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    protected final byte[] getBytes() {
        return this.bytes;
    }

    public final byte[] readBytes(int amount) throws IOException {
        byte[] result = new byte[amount];
        int has = this.size - this.byteIndex;
        if (amount >= has) {
            ReadableByteChannel c = this.channel;
            System.arraycopy(this.bytes, this.byteIndex, result, 0, has);
            ByteBuffer bb2 = ByteBuffer.wrap(result);
            bb2.position(has);
            while (has < amount) {
                has += c.read(bb2);
            }
            this.getSome();
        } else {
            System.arraycopy(this.bytes, this.byteIndex, result, 0, amount);
            this.byteIndex += amount;
        }
        return result;
    }

    public final void getSome() throws IOException {
        ReadableByteChannel c = this.channel;
        ByteBuffer bb = this.byteBuffer;
        bb.position(0);
        bb.limit(BUFFER);
        this.size = c.read(bb);
        if (this.size == 0) {
            long start = System.nanoTime();
            while (this.size == 0) {
                if (System.nanoTime() - start > 10000000000L) {
                    throw new IOException("Timeout");
                }
                this.size = c.read(bb);
            }
        }
        bb.position(0);
        this.byteIndex = 0;
    }

    public final int readShort() throws IOException {
        if (this.byteIndex >= this.size - 3) {
            int result = 0;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result = (short)(result | (short)(this.bytes[this.byteIndex++] & 0xFF) << 0);
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result = (short)(result | (short)(this.bytes[this.byteIndex++] & 0xFF) << 8);
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            return result;
        }
        int result = Bytes.readLE2((byte[])this.bytes, (int)this.byteIndex);
        this.byteIndex += 2;
        return result;
    }

    public final int readInt() throws IOException {
        if (this.byteIndex >= this.size - 5) {
            int result = 0;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (this.bytes[this.byteIndex++] & 0xFF) << 0;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (this.bytes[this.byteIndex++] & 0xFF) << 8;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (this.bytes[this.byteIndex++] & 0xFF) << 16;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (this.bytes[this.byteIndex++] & 0xFF) << 24;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            return result;
        }
        int result = Bytes.readLE4((byte[])this.bytes, (int)this.byteIndex);
        this.byteIndex += 4;
        return result;
    }

    public final long readLong() throws IOException {
        if (this.byteIndex >= this.size - 9) {
            long result = 0L;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (long)(this.bytes[this.byteIndex++] & 0xFF) << 0;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (long)(this.bytes[this.byteIndex++] & 0xFF) << 8;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (long)(this.bytes[this.byteIndex++] & 0xFF) << 16;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (long)(this.bytes[this.byteIndex++] & 0xFF) << 24;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (long)(this.bytes[this.byteIndex++] & 0xFF) << 32;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (long)(this.bytes[this.byteIndex++] & 0xFF) << 40;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (long)(this.bytes[this.byteIndex++] & 0xFF) << 48;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            result |= (long)(this.bytes[this.byteIndex++] & 0xFF) << 56;
            if (this.byteIndex == this.size) {
                this.getSome();
            }
            return result;
        }
        long result = Bytes.readLE8((byte[])this.bytes, (int)this.byteIndex);
        this.byteIndex += 8;
        return result;
    }

    public void close() {
        try {
            this.fs.close();
        }
        catch (IOException e) {
            Logger.defaultLogError(e);
        }
    }

    public ByteFileReader(File file) throws IOException {
        this.byteBuffer = ByteBuffer.wrap(this.bytes);
        this.fs = new FileInputStream(file);
        this.channel = this.fs.getChannel();
        this.size = this.channel.read(this.byteBuffer);
        this.byteBuffer.position(0);
    }
}

