package org.simantics.db.common.utils;

import java.util.Collections;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.MapList;

public class VersionInfoRequest extends ResourceRead<VersionInfo> {

	public VersionInfoRequest(Resource resource) {
		super(resource);
	}
    
	@Override
	public VersionInfo perform(ReadGraph graph) throws DatabaseException {
		
    	Layer0 L0 = Layer0.getInstance(graph);

    	String baseName = graph.getPossibleRelatedValue(resource, L0.HasName, Bindings.STRING);
    	String version = "";
    	
    	if(baseName != null) {
    		int pos = baseName.lastIndexOf('@');
    		if(pos != -1) {
    			version = baseName.substring(pos+1);
    			baseName = baseName.substring(0, pos);
    		}
    	}
    	
		Resource parent = graph.getPossibleObject(resource, L0.PartOf);
		if(parent != null) {
			MapList<String,NamedResource> versionMap = graph.syncRequest(new VersionMapRequest(parent));
			return new VersionInfo(baseName, version, versionMap.getValues(baseName));
		}

		return new VersionInfo(baseName, version, Collections.singleton(new NamedResource(version, resource)));
		
	}

}
