/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.utils;

import java.io.IOException;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;

public class Serializers {
    public static byte[] serializeStrings(String[] properties)
    throws IOException, SerializerConstructionException, SerializationException, BindingException, BindingConstructionException {
    	Binding b = Bindings.getBinding(String[].class);
    	Serializer s = Bindings.getSerializer(b);
    	byte[] data = s.serialize(properties);
    	return data;
    }
    public static String[] deserializeStrings(byte[] data)
    throws IOException, SerializerConstructionException, SerializationException, BindingException {
    	Binding b = Bindings.getBindingUnchecked(String[].class);
    	Serializer s = Bindings.getSerializer(b);
    	String[] ss = (String[])s.deserialize(data);
    	return ss;
    }
}
