package org.simantics.db.common.utils;

import java.lang.reflect.Method;
import java.util.Map;

import org.simantics.db.Metadata;

public class MetadataUtil {
    @SuppressWarnings("unchecked")
    public static <T> T getMetadata(Map<String, byte[]> data, Class<? extends Metadata> dataClass) {
        if (null == data || null == dataClass)
            return null;
        T result = null;
        try {
            Method m = dataClass.getMethod("deserialise", byte[].class);
            byte[] bytes = data.get(dataClass.getName());
            if (null != bytes) {
                Object value = m.invoke(null, bytes);
                result = (T)value;
            } else
                return null;
        } catch (RuntimeException e) {
            Logger.defaultLogError(e);
        } catch (Exception e) {
            Logger.defaultLogError(e);
        }
        return result;
    }
}
