/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.uri;

import java.util.regex.Pattern;


class URIEscape {

    private static final String  HTTP       = "http:/";
    private static final String  HTTP_SLASH = "http://";

    private static final Pattern slash = Pattern.compile("/");

    /**
     * Escapes the specified name by changing spaces (' ') into underscores
     * ('_').
     * 
     * @param name name to escape
     * @return
     * @deprecated do not use, this is not the DB standard to URI escaping.
     */
    @Deprecated
    public static String escapeName(String name) {
        char[] chars = name.toCharArray();
        boolean modified = false;
        for(int i=0;i<chars.length;++i)
            if(!Character.isJavaIdentifierPart(chars[i])) {
                chars[i] = '_';
                modified = true;
            }
        if(modified)
            return new String(chars);
        else
            return name;
    }

    public static String[] splitURI(String uri) {
        if(!uri.startsWith(HTTP_SLASH))
            throw new IllegalArgumentException("Uri does not begin with '" + HTTP_SLASH + "'. given uri: " + uri);
        return slash.split(uri.substring(7));
    }

    public static String joinURI(String[] names) {
        StringBuilder b = new StringBuilder();
        b.append(HTTP);
        for(String name : names) {
            b.append('/');
            b.append(name);
        }
        return b.toString();
    }

}
