/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 * @since 1.41.0, 1.35.2
 */
public class TypeURIs extends ResourceRead<Set<String>> {

    public TypeURIs(Resource r) {
        super(r);
    }

    @Override
    public Set<String> perform(ReadGraph graph) throws DatabaseException {
        Set<Resource> types = graph.getTypes(resource);
        return graph.syncRequest(new ResourceSetURIs(types));
    }

}